/*
 * Decompiled with CFR 0.152.
 */
package org.jdeferred.impl;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jdeferred.DeferredCallable;
import org.jdeferred.DeferredFutureTask;
import org.jdeferred.DeferredManager;
import org.jdeferred.DeferredRunnable;
import org.jdeferred.Promise;
import org.jdeferred.multiple.MasterDeferredObject;
import org.jdeferred.multiple.MasterProgress;
import org.jdeferred.multiple.MultipleResults;
import org.jdeferred.multiple.OneReject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDeferredManager
implements DeferredManager {
    protected final Logger log = LoggerFactory.getLogger(AbstractDeferredManager.class);

    protected abstract void submit(Runnable var1);

    protected abstract void submit(Callable var1);

    public abstract boolean isAutoSubmit();

    @Override
    public Promise<MultipleResults, OneReject, MasterProgress> when(Runnable ... runnables) {
        this.assertNotEmpty(runnables);
        Promise[] promises = new Promise[runnables.length];
        for (int i = 0; i < runnables.length; ++i) {
            promises[i] = runnables[i] instanceof DeferredRunnable ? this.when((DeferredRunnable<P>)((DeferredRunnable)runnables[i])) : this.when(runnables[i]);
        }
        return this.when(promises);
    }

    @Override
    public Promise<MultipleResults, OneReject, MasterProgress> when(Callable<?> ... callables) {
        this.assertNotEmpty(callables);
        Promise[] promises = new Promise[callables.length];
        for (int i = 0; i < callables.length; ++i) {
            promises[i] = callables[i] instanceof DeferredCallable ? this.when((DeferredCallable<D, P>)((DeferredCallable)callables[i])) : this.when((Callable)callables[i]);
        }
        return this.when(promises);
    }

    @Override
    public Promise<MultipleResults, OneReject, MasterProgress> when(DeferredRunnable<?> ... runnables) {
        this.assertNotEmpty(runnables);
        Promise[] promises = new Promise[runnables.length];
        for (int i = 0; i < runnables.length; ++i) {
            promises[i] = this.when((DeferredRunnable<P>)runnables[i]);
        }
        return this.when(promises);
    }

    @Override
    public Promise<MultipleResults, OneReject, MasterProgress> when(DeferredCallable<?, ?> ... callables) {
        this.assertNotEmpty(callables);
        Promise[] promises = new Promise[callables.length];
        for (int i = 0; i < callables.length; ++i) {
            promises[i] = this.when((DeferredCallable<D, P>)callables[i]);
        }
        return this.when(promises);
    }

    @Override
    public Promise<MultipleResults, OneReject, MasterProgress> when(DeferredFutureTask<?, ?> ... tasks) {
        this.assertNotEmpty(tasks);
        Promise[] promises = new Promise[tasks.length];
        for (int i = 0; i < tasks.length; ++i) {
            promises[i] = this.when((DeferredFutureTask<D, P>)tasks[i]);
        }
        return this.when(promises);
    }

    @Override
    public Promise<MultipleResults, OneReject, MasterProgress> when(Future<?> ... futures) {
        this.assertNotEmpty(futures);
        Promise[] promises = new Promise[futures.length];
        for (int i = 0; i < futures.length; ++i) {
            promises[i] = this.when((Future)futures[i]);
        }
        return this.when(promises);
    }

    @Override
    public Promise<MultipleResults, OneReject, MasterProgress> when(Promise ... promises) {
        this.assertNotEmpty(promises);
        return new MasterDeferredObject(promises).promise();
    }

    @Override
    public <D, F, P> Promise<D, F, P> when(Promise<D, F, P> promise) {
        return promise;
    }

    @Override
    public <P> Promise<Void, Throwable, P> when(DeferredRunnable<P> runnable) {
        return this.when((DeferredFutureTask<D, P>)new DeferredFutureTask(runnable));
    }

    @Override
    public <D, P> Promise<D, Throwable, P> when(DeferredCallable<D, P> runnable) {
        return this.when(new DeferredFutureTask<D, P>(runnable));
    }

    @Override
    public Promise<Void, Throwable, Void> when(Runnable runnable) {
        return this.when((DeferredFutureTask<D, P>)new DeferredFutureTask(runnable));
    }

    @Override
    public <D> Promise<D, Throwable, Void> when(Callable<D> callable) {
        return this.when((DeferredFutureTask<D, P>)new DeferredFutureTask(callable));
    }

    @Override
    public <D, P> Promise<D, Throwable, P> when(DeferredFutureTask<D, P> task) {
        if (task.getStartPolicy() == DeferredManager.StartPolicy.AUTO || task.getStartPolicy() == DeferredManager.StartPolicy.DEFAULT && this.isAutoSubmit()) {
            this.submit(task);
        }
        return task.promise();
    }

    @Override
    public <D> Promise<D, Throwable, Void> when(final Future<D> future) {
        return this.when((DeferredCallable<D, P>)new DeferredCallable<D, Void>(DeferredManager.StartPolicy.AUTO){

            @Override
            public D call() throws Exception {
                try {
                    return future.get();
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof Exception) {
                        throw (Exception)e.getCause();
                    }
                    throw e;
                }
            }
        });
    }

    protected void assertNotEmpty(Object[] objects) {
        if (objects == null || objects.length == 0) {
            throw new IllegalArgumentException("Arguments is null or its length is empty");
        }
    }
}

