/*
 * Decompiled with CFR 0.152.
 */
package org.jdeferred;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.jdeferred.Deferred;
import org.jdeferred.DeferredCallable;
import org.jdeferred.DeferredManager;
import org.jdeferred.DeferredRunnable;
import org.jdeferred.Promise;
import org.jdeferred.impl.DeferredObject;

public class DeferredFutureTask<D, P>
extends FutureTask<D> {
    protected final Deferred<D, Throwable, P> deferred;
    protected final DeferredManager.StartPolicy startPolicy;

    public DeferredFutureTask(Callable<D> callable) {
        super(callable);
        this.deferred = new DeferredObject<D, Throwable, P>();
        this.startPolicy = DeferredManager.StartPolicy.DEFAULT;
    }

    public DeferredFutureTask(Runnable runnable) {
        super(runnable, null);
        this.deferred = new DeferredObject<D, Throwable, P>();
        this.startPolicy = DeferredManager.StartPolicy.DEFAULT;
    }

    public DeferredFutureTask(DeferredCallable<D, P> callable) {
        super(callable);
        this.deferred = callable.getDeferred();
        this.startPolicy = callable.getStartPolicy();
    }

    public DeferredFutureTask(DeferredRunnable<P> runnable) {
        super(runnable, null);
        this.deferred = runnable.getDeferred();
        this.startPolicy = runnable.getStartPolicy();
    }

    public Promise<D, Throwable, P> promise() {
        return this.deferred.promise();
    }

    @Override
    protected void done() {
        try {
            if (this.isCancelled()) {
                this.deferred.reject(new CancellationException());
            }
            Object result = this.get();
            this.deferred.resolve(result);
        }
        catch (InterruptedException e) {
        }
        catch (ExecutionException e) {
            this.deferred.reject(e.getCause());
        }
    }

    public DeferredManager.StartPolicy getStartPolicy() {
        return this.startPolicy;
    }
}

