/*
 * Decompiled with CFR 0.152.
 */
package com.kidbei.rainbow.transport.netty;

import com.kidbei.rainbow.core.exception.RainbowNetException;
import com.kidbei.rainbow.core.transport.CMasterSession;
import com.kidbei.rainbow.transport.netty.NettySession;
import com.kidbei.rainbow.transport.netty.bootstrap.NettyBootstrap;
import io.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyCMasterSession
extends NettySession
implements CMasterSession {
    private static final Logger log = LoggerFactory.getLogger(NettyCMasterSession.class);
    private String host;
    private int port;
    private NettyBootstrap bootstrap;

    public NettyCMasterSession(Channel channel) {
        super(channel);
    }

    @Override
    public String getRemoteAddress() {
        return this.host + ":" + this.port;
    }

    public NettyCMasterSession(Channel channel, String host, int port) {
        super(channel);
        this.host = host;
        this.port = port;
    }

    @Override
    public void disconnectServer() {
        try {
            if (this.bootstrap != null) {
                this.bootstrap.shutdown();
            }
            this.channel.disconnect().sync().awaitUninterruptibly();
        }
        catch (Exception e) {
            throw new RainbowNetException("disconnect remote server " + this.host + ":" + this.port + " failed", e);
        }
    }

    public void setBootstrap(NettyBootstrap bootstrap) {
        this.bootstrap = bootstrap;
    }
}

