/*
 * Decompiled with CFR 0.152.
 */
package com.kidbei.rainbow.registry.impl;

import com.kidbei.rainbow.core.exception.RegistryException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkOps {
    private static final Logger log = LoggerFactory.getLogger(ZkOps.class);
    private ZooKeeper zk;

    public ZkOps(ZooKeeper zk) {
        this.zk = zk;
    }

    public void createByRecursion(String location, byte[] data, CreateMode createMode) {
        try {
            if (this.isExists(location)) {
                log.warn("path {} is already exists", (Object)location);
            } else {
                this.zk.create(location, data, ZooDefs.Ids.OPEN_ACL_UNSAFE, createMode);
            }
        }
        catch (Exception e) {
            if (e instanceof KeeperException.NoNodeException) {
                log.warn("parent path is not exist,create by recursion");
                ArrayList<String> locations = new ArrayList<String>();
                locations.addAll(Arrays.asList(location.split("/")));
                locations.remove(locations.size() - 1);
                locations.remove("");
                this.createByOrder(locations);
                this.createByRecursion(location, data, createMode);
            }
            if (e instanceof KeeperException.NodeExistsException) {
                log.warn("path is already exists,path={}", (Object)location);
            }
            throw new RegistryException("\u521b\u5efa\u8def\u5f84\u5931\u8d25,path=" + location, e);
        }
    }

    public void createByOrder(List<String> locations) {
        if (locations != null && locations.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (String location : locations) {
                sb.append("/").append(location);
                String path = sb.toString();
                if (log.isDebugEnabled()) {
                    log.debug("create path:{}", (Object)path);
                }
                if (this.isExists(path)) continue;
                this.createPath(path, "".getBytes(), CreateMode.PERSISTENT);
            }
        }
    }

    public boolean isExists(String path) {
        try {
            Stat stat = this.zk.exists(path, null);
            return stat != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void createPath(String path, byte[] data, CreateMode createMode) {
        try {
            this.zk.create(path, data, ZooDefs.Ids.OPEN_ACL_UNSAFE, createMode);
        }
        catch (Exception e) {
            log.error("create path error:path={}", (Object)path);
        }
    }
}

