/*
 * Decompiled with CFR 0.152.
 */
package com.kidbei.rainbow.core.server;

import com.kidbei.rainbow.core.context.bean.ServiceDeffer;
import com.kidbei.rainbow.core.context.mapping.ProMethodMapping;
import com.kidbei.rainbow.core.registry.RainbowRegistry;
import com.kidbei.rainbow.core.serialize.RainbowSerializer;
import com.kidbei.rainbow.core.serialize.impl.KryoSerializer;
import com.kidbei.rainbow.core.serialize.impl.StringSerializer;
import com.kidbei.rainbow.core.transport.RainbowTransport;
import com.kidbei.rainbow.core.util.IPHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ForkJoinPool;

public class RainbowServerOptions {
    private RainbowTransport transport;
    private RainbowRegistry registry;
    private String localHost;
    private String bindHost = "0.0.0.0";
    private int port;
    private String group = "rainbow";
    private ProMethodMapping methodMapping = new ProMethodMapping();
    private List<ServiceDeffer> serviceDeffers = new ArrayList<ServiceDeffer>();
    private RainbowSerializer[] serializers = new RainbowSerializer[]{new KryoSerializer(), new StringSerializer()};
    private AbstractExecutorService threadPool = new ForkJoinPool(100);

    public RainbowServerOptions(RainbowTransport transport, RainbowRegistry registry, int port) {
        this.transport = transport;
        this.registry = registry;
        this.port = port;
        this.localHost = IPHelper.getInnerHostIp();
        this.bindHost = "0.0.0.0";
    }

    public RainbowServerOptions(RainbowTransport transport, RainbowRegistry registry, String localHost, String bindHost, int port) {
        this.transport = transport;
        this.registry = registry;
        this.localHost = localHost;
        this.bindHost = bindHost;
        this.port = port;
    }

    public RainbowServerOptions addServiceObj(Object serviceObj) {
        this.addServiceObj(serviceObj, 1);
        return this;
    }

    public RainbowServerOptions addServiceObj(Object serviceObj, int version) {
        if (version > 127) {
            throw new IllegalArgumentException("\u7248\u672c\u53f7\u5fc5\u987b\u4ecb\u4e8e-128\u5230127\u4e4b\u95f4");
        }
        this.methodMapping.addInstance(serviceObj, (byte)version);
        this.serviceDeffers.add(new ServiceDeffer(serviceObj, (byte)version));
        return this;
    }

    public RainbowTransport getTransport() {
        return this.transport;
    }

    public void setTransport(RainbowTransport transport) {
        this.transport = transport;
    }

    public RainbowRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(RainbowRegistry registry) {
        this.registry = registry;
    }

    public String getLocalHost() {
        return this.localHost;
    }

    public void setLocalHost(String localHost) {
        this.localHost = localHost;
    }

    public String getBindHost() {
        return this.bindHost;
    }

    public void setBindHost(String bindHost) {
        this.bindHost = bindHost;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public List<ServiceDeffer> getServiceDeffers() {
        return this.serviceDeffers;
    }

    public RainbowSerializer[] getSerializers() {
        return this.serializers;
    }

    public RainbowServerOptions setSerializers(RainbowSerializer[] serializers) {
        this.serializers = serializers;
        return this;
    }

    public ProMethodMapping getMethodMapping() {
        return this.methodMapping;
    }

    public AbstractExecutorService getThreadPool() {
        return this.threadPool;
    }

    public RainbowServerOptions setThreadPool(AbstractExecutorService threadPool) {
        this.threadPool = threadPool;
        return this;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }
}

