/*
 * Decompiled with CFR 0.152.
 */
package com.kidbei.rainbow.core.protocol.codec;

import com.kidbei.rainbow.core.buffer.RPCBuf;
import com.kidbei.rainbow.core.exception.ProtocolException;
import com.kidbei.rainbow.core.protocol.ResultType;
import com.kidbei.rainbow.core.protocol.StandardHeader;
import com.kidbei.rainbow.core.protocol.codec.FuncResponse;
import com.kidbei.rainbow.core.protocol.codec.PayloadCodec;
import com.kidbei.rainbow.core.transport.RainbowSession;

public class ResponsePayloadCodec
implements PayloadCodec<FuncResponse, FuncResponse> {
    @Override
    public RPCBuf code(RainbowSession session, StandardHeader header, FuncResponse response) {
        int size = 22;
        ResultType resultType = response.resultType;
        byte[] resultBytes = response.result;
        size += resultBytes.length;
        byte[] returnTypeBytes = null;
        if (response.hasReturnType) {
            size += 2;
            returnTypeBytes = response.returnType.getName().getBytes();
            size += returnTypeBytes.length;
        }
        header.setLen(size);
        RPCBuf buf = session.buffer(size);
        header.writeToBuf(buf);
        buf.writeByte(response.serializer);
        buf.writeByte((byte)resultType.ordinal());
        buf.writeBool(response.hasReturnType);
        if (response.hasReturnType) {
            buf.writeShort((short)returnTypeBytes.length);
            buf.writeBytes(returnTypeBytes);
        }
        buf.writeBytes(resultBytes);
        return buf;
    }

    @Override
    public FuncResponse decode(StandardHeader header, RPCBuf buf) {
        try {
            FuncResponse response = new FuncResponse();
            byte serializeType = buf.readByte();
            ResultType resultType = ResultType.valueOf(buf.readByte());
            boolean hasReturnType = buf.readBool();
            if (hasReturnType) {
                short len = buf.readShort();
                byte[] bytes = new byte[len];
                buf.readBytes(bytes);
                String returnClassName = new String(bytes);
                response.returnType = Class.forName(returnClassName);
            }
            byte[] body = buf.readRemain();
            response.hasReturnType = hasReturnType;
            response.result = body;
            response.resultType = resultType;
            response.serializer = serializeType;
            return response;
        }
        catch (Exception e) {
            throw new ProtocolException(e);
        }
    }

    @Override
    public byte payloadType() {
        return 2;
    }
}

