/*
 * Decompiled with CFR 0.152.
 */
package com.kidbei.rainbow.core.handler.result;

import com.kidbei.rainbow.core.context.bean.ProMethod;
import com.kidbei.rainbow.core.handler.result.BaseReturnValueHandler;
import com.kidbei.rainbow.core.handler.result.ReturnValueHandler;
import com.kidbei.rainbow.core.protocol.StandardHeader;
import com.kidbei.rainbow.core.protocol.codec.FuncRequest;
import com.kidbei.rainbow.core.protocol.codec.ResponsePayloadCodec;
import com.kidbei.rainbow.core.serialize.RainbowSerializer;
import com.kidbei.rainbow.core.transport.RainbowSession;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompletableReturnValueHandler
extends BaseReturnValueHandler
implements ReturnValueHandler {
    private final Logger log = LoggerFactory.getLogger(CompletableReturnValueHandler.class);

    public CompletableReturnValueHandler(RainbowSerializer[] serializers, ResponsePayloadCodec responsePayloadCodec) {
        super(serializers, responsePayloadCodec);
    }

    @Override
    public boolean support(Object returnValue, ProMethod method) {
        return returnValue instanceof CompletableFuture;
    }

    @Override
    public void handle(RainbowSession session, FuncRequest request, StandardHeader header, ProMethod method, RainbowSerializer serializer, Object returnValue) {
        CompletableFuture future = (CompletableFuture)returnValue;
        ((CompletableFuture)future.whenComplete((result, o2) -> {
            if (this.log.isDebugEnabled()) {
                this.log.debug("completable done with value:{}", result);
            }
            this.writeResult(session, request, header, serializer, result);
        })).exceptionally(throwable -> {
            this.log.error("completableFuture got an error", throwable);
            this.writeError(session, header, request, throwable.toString());
            return null;
        });
    }
}

