/*
 * Decompiled with CFR 0.152.
 */
package com.kidbei.rainbow.core.handler;

import com.kidbei.rainbow.core.buffer.RPCBuf;
import com.kidbei.rainbow.core.context.bean.ProMethod;
import com.kidbei.rainbow.core.context.mapping.ProMethodMapping;
import com.kidbei.rainbow.core.exception.ReturnValueNotSupportException;
import com.kidbei.rainbow.core.handler.MessageHandler;
import com.kidbei.rainbow.core.handler.result.CompletableReturnValueHandler;
import com.kidbei.rainbow.core.handler.result.PromiseAsyncReturnValueHandler;
import com.kidbei.rainbow.core.handler.result.ReturnValueHandler;
import com.kidbei.rainbow.core.handler.result.ReturnValueHandlerProcessor;
import com.kidbei.rainbow.core.handler.result.RxjavaAsyncReturnValueHandler;
import com.kidbei.rainbow.core.protocol.ResultType;
import com.kidbei.rainbow.core.protocol.StandardHeader;
import com.kidbei.rainbow.core.protocol.codec.FuncRequest;
import com.kidbei.rainbow.core.protocol.codec.FuncResponse;
import com.kidbei.rainbow.core.protocol.codec.HashURIRequestPayloadCodec;
import com.kidbei.rainbow.core.protocol.codec.PayloadCodec;
import com.kidbei.rainbow.core.protocol.codec.ResponsePayloadCodec;
import com.kidbei.rainbow.core.serialize.RainbowSerializer;
import com.kidbei.rainbow.core.serialize.impl.StringSerializer;
import com.kidbei.rainbow.core.transport.RainbowSession;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.AbstractExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerMessageHandler
implements MessageHandler {
    private static final Logger log = LoggerFactory.getLogger(ServerMessageHandler.class);
    private final RainbowSerializer[] serializers;
    private final StringSerializer stringSerializer;
    private final PayloadCodec<FuncRequest, FuncRequest> codec;
    private final ProMethodMapping methodMapping;
    private final AbstractExecutorService threadPool;
    private final ResponsePayloadCodec responseCodec;
    private final List<ReturnValueHandler> returnValueHandlers = new ArrayList<ReturnValueHandler>();
    private final Map<ProMethod, ReturnValueHandler> returnValueHandlerMap = new HashMap<ProMethod, ReturnValueHandler>();

    public ServerMessageHandler(RainbowSerializer[] serializers, ProMethodMapping methodMapping, AbstractExecutorService threadPool) {
        this.serializers = serializers;
        this.codec = new HashURIRequestPayloadCodec();
        this.methodMapping = methodMapping;
        this.threadPool = threadPool;
        this.responseCodec = new ResponsePayloadCodec();
        this.stringSerializer = (StringSerializer)serializers[1];
        this.initReturnValueHandlers();
    }

    protected void initReturnValueHandlers() {
        this.returnValueHandlers.add(new PromiseAsyncReturnValueHandler(this.serializers, this.responseCodec));
        this.returnValueHandlers.add(new RxjavaAsyncReturnValueHandler(this.serializers, this.responseCodec));
        this.returnValueHandlers.add(new CompletableReturnValueHandler(this.serializers, this.responseCodec));
        this.returnValueHandlers.add(new ReturnValueHandlerProcessor(this.serializers, this.responseCodec, this.returnValueHandlers));
    }

    @Override
    public void messageReceived(RainbowSession session, RPCBuf rpcBuf) {
        if (log.isDebugEnabled()) {
            log.debug("receive message from {}", (Object)session);
        }
        StandardHeader header = StandardHeader.read(rpcBuf);
        if (log.isDebugEnabled()) {
            log.debug("receive message header : {}", (Object)header);
        }
        FuncRequest request = this.codec.decode(header, rpcBuf);
        ProMethod method = this.methodMapping.getRPCMethod(request.uri, header.version());
        this.threadPool.execute(() -> {
            Object result;
            RainbowSerializer serializer = this.serializers[request.serializer];
            byte[] argsBody = request.params;
            if (method.hasParameters()) {
                Object[] args = new Object[method.getParamTypes().length];
                if (argsBody != null && argsBody.length > 0) {
                    args = (Object[])serializer.decode(argsBody, method.getParamTypes().getClass());
                }
                try {
                    result = method.invokeMethod(args);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.writeError(session, header, request, "\u65b9\u6cd5\u6267\u884c\u5931\u8d25:" + e.toString());
                    return;
                }
            }
            try {
                result = method.invokeMethod(null);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.writeError(session, header, request, "\u65b9\u6cd5\u6267\u884c\u5931\u8d25:" + e.toString());
                return;
            }
            ReturnValueHandler returnValueHandler = this.returnValueHandlerMap.get(method);
            if (returnValueHandler == null) {
                for (ReturnValueHandler handler : this.returnValueHandlers) {
                    if (!handler.support(result, method)) continue;
                    returnValueHandler = handler;
                    this.returnValueHandlerMap.put(method, handler);
                    break;
                }
                if (returnValueHandler == null) {
                    throw new ReturnValueNotSupportException();
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("use return value handler {}", (Object)returnValueHandler);
            }
            returnValueHandler.handle(session, request, header, method, serializer, result);
        });
    }

    protected void writeError(RainbowSession session, StandardHeader header, FuncRequest request, String errorMessage) {
        FuncResponse response = new FuncResponse();
        response.hasReturnType = !request.hasReturnType;
        response.serializer = this.stringSerializer.flag();
        response.result = this.stringSerializer.encode(errorMessage);
        response.resultType = ResultType.ERROR;
        RPCBuf buf = this.responseCodec.code(session, header, response);
        session.write(buf);
    }
}

