/*
 * Decompiled with CFR 0.152.
 */
package com.kidbei.rainbow.core.context.bean;

import com.kidbei.rainbow.core.context.annotation.RMethod;
import com.kidbei.rainbow.core.context.annotation.RService;
import com.kidbei.rainbow.core.context.bean.ProMethodParam;
import com.kidbei.rainbow.core.context.mapping.MappingGetter;
import com.kidbei.rainbow.core.context.mapping.impl.MappingGetterImpl;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class ProMethod {
    private String name;
    private boolean hasParameters;
    private int alias;
    private ProMethodParam[] proMethodParams;
    private Method method;
    private Method ownerMethod;
    private Object owner;
    private RMethod rpcMethodAnnotation;
    private List<String> uris;
    private String simplifyUri;
    private MappingGetter getter = new MappingGetterImpl();
    private Class<?> ownerInterface;
    private Class<?> ownerClass;
    private boolean mustReturn;
    private Class<?> returnType;
    private Class<?>[] paramTypes;

    public ProMethod(Method method, Object owner) throws NoSuchMethodException {
        this.method = method;
        this.owner = owner;
        this.ownerClass = owner.getClass();
        this.returnType = method.getReturnType();
        this.mustReturn = this.returnType != null;
        this.rpcMethodAnnotation = this.getRpcMethodAnnotation();
        this.hasParameters = method.getParameterTypes() != null && method.getParameterTypes().length > 0;
        this.ownerMethod = this.ownerClass.getMethod(method.getName(), method.getParameterTypes());
        this.name = this.method.getName();
        this.alias = this.name.hashCode();
        this.paramTypes = this.method.getParameterTypes();
    }

    public String getName() {
        return this.name;
    }

    public boolean hasParameters() {
        return this.hasParameters;
    }

    public int getAlias() {
        return this.alias;
    }

    public ProMethod() {
    }

    public boolean isMustReturn() {
        return this.mustReturn;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public Class<?>[] getParamTypes() {
        return this.paramTypes;
    }

    public RMethod getRpcMethodAnnotation() {
        if (this.rpcMethodAnnotation == null) {
            this.rpcMethodAnnotation = this.method.getAnnotation(RMethod.class);
        }
        return this.rpcMethodAnnotation;
    }

    public Class<?> getRPCServiceInterface() {
        if (this.ownerInterface == null) {
            for (Class<?> infs : this.ownerClass.getInterfaces()) {
                RService rService = infs.getAnnotation(RService.class);
                if (rService == null) continue;
                this.ownerInterface = infs;
                break;
            }
        }
        return this.ownerInterface;
    }

    public List<String> getUris() {
        if (this.uris == null) {
            this.uris = this.getter.getMethodUrls(this.ownerInterface, this.method);
        }
        return this.uris;
    }

    public String getSimplifyUri() {
        if (this.simplifyUri == null) {
            this.simplifyUri = this.getter.getSimpleMethodUrl(this.ownerInterface, this.method);
        }
        return this.simplifyUri;
    }

    public ProMethodParam[] getProMethodParams() {
        if (this.proMethodParams != null) {
            Class<?>[] params = this.method.getParameterTypes();
            if (params == null) {
                this.proMethodParams = new ProMethodParam[0];
            } else {
                this.proMethodParams = new ProMethodParam[params.length];
                for (int i = 0; i < params.length; ++i) {
                    ProMethodParam proMethodParam;
                    this.proMethodParams[i] = proMethodParam = new ProMethodParam(this.ownerMethod, params[i], i);
                }
            }
        }
        return this.proMethodParams;
    }

    public Object invokeMethod(Object[] params) throws InvocationTargetException, IllegalAccessException {
        return this.ownerMethod.invoke(this.owner, params);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ProMethod{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", alias=").append(this.alias);
        sb.append(", ownerMethod=").append(this.ownerMethod);
        sb.append('}');
        return sb.toString();
    }
}

