/*
 * Decompiled with CFR 0.152.
 */
package com.kidbei.rainbow.core.client;

import com.kidbei.rainbow.core.loadbalance.LoadBalancer;
import com.kidbei.rainbow.core.loadbalance.impl.RoundRobinLoadBalancer;
import com.kidbei.rainbow.core.registry.RainbowRegistry;
import com.kidbei.rainbow.core.serialize.RainbowSerializer;
import com.kidbei.rainbow.core.serialize.impl.KryoSerializer;
import com.kidbei.rainbow.core.transport.RainbowTransport;
import com.kidbei.rainbow.core.util.SeqGenerator;
import com.kidbei.rainbow.core.util.impl.AtomicSeqGenerator;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ForkJoinPool;

public class RainbowClientOptions {
    private RainbowTransport transport;
    private int defaultVersion = 1;
    private String group = "rainbow";
    private LoadBalancer loadBalancer = new RoundRobinLoadBalancer();
    private RainbowRegistry registry;
    private SeqGenerator seqGenerator = new AtomicSeqGenerator();
    private RainbowSerializer[] serializers = new RainbowSerializer[]{new KryoSerializer()};
    private AbstractExecutorService threadPool = new ForkJoinPool(Runtime.getRuntime().availableProcessors());
    private long timeout = 10000L;

    public void addSerializer(RainbowSerializer serializer) {
        this.addSerializer(serializer);
    }

    public RainbowClientOptions setVersion(int version) {
        this.defaultVersion = version;
        return this;
    }

    public RainbowClientOptions setGroup(String group) {
        this.group = group;
        return this;
    }

    public LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public RainbowClientOptions setLoadBalancer(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
        return this;
    }

    public RainbowRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(RainbowRegistry registry) {
        this.registry = registry;
    }

    public RainbowTransport getTransport() {
        return this.transport;
    }

    public void setTransport(RainbowTransport transport) {
        this.transport = transport;
    }

    public int getVersion() {
        return this.defaultVersion;
    }

    public String getGroup() {
        return this.group;
    }

    public SeqGenerator getSeqGenerator() {
        return this.seqGenerator;
    }

    public RainbowClientOptions setSeqGenerator(SeqGenerator seqGenerator) {
        this.seqGenerator = seqGenerator;
        return this;
    }

    public RainbowSerializer[] getSerializers() {
        return this.serializers;
    }

    public RainbowClientOptions setSerializers(RainbowSerializer[] serializers) {
        this.serializers = serializers;
        return this;
    }

    public AbstractExecutorService getThreadPool() {
        return this.threadPool;
    }

    public RainbowClientOptions setThreadPool(AbstractExecutorService threadPool) {
        this.threadPool = threadPool;
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public RainbowClientOptions setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }
}

