/*
 * Decompiled with CFR 0.152.
 */
package com.kidbei.rainbow.core.buffer.impl;

import com.kidbei.rainbow.core.buffer.RPCBuf;

public class RainbowRPCBuf
implements RPCBuf {
    private byte[] payload = new byte[0];
    private int rIdx = 0;
    private int rwIdx = 0;

    public RainbowRPCBuf() {
    }

    public RainbowRPCBuf(byte[] bytes) {
        this.payload = bytes;
    }

    @Override
    public RainbowRPCBuf buffer(int size) {
        this.payload = new byte[size];
        return this;
    }

    @Override
    public RainbowRPCBuf writeInt(int data) {
        this.payload[this.rwIdx] = (byte)(data >> 0);
        ++this.rwIdx;
        this.payload[this.rwIdx] = (byte)(data >> 8);
        ++this.rwIdx;
        this.payload[this.rwIdx] = (byte)(data >> 16);
        ++this.rwIdx;
        this.payload[this.rwIdx] = (byte)(data >> 24);
        ++this.rwIdx;
        return this;
    }

    @Override
    public RainbowRPCBuf writeBool(boolean data) {
        int value = data ? 1 : 0;
        this.payload[this.rwIdx] = (byte)(value >> 0);
        ++this.rwIdx;
        return this;
    }

    @Override
    public RainbowRPCBuf writeByte(byte data) {
        this.payload[this.rwIdx] = data;
        ++this.rwIdx;
        return this;
    }

    @Override
    public RainbowRPCBuf writeBytes(byte[] data) {
        byte[] byArray = data;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byte b;
            this.payload[this.rwIdx] = b = byArray[i];
            ++this.rwIdx;
        }
        return this;
    }

    @Override
    public RainbowRPCBuf writeLong(long data) {
        this.payload[this.rwIdx] = (byte)(data >> 0);
        ++this.rwIdx;
        this.payload[this.rwIdx] = (byte)(data >> 8);
        ++this.rwIdx;
        this.payload[this.rwIdx] = (byte)(data >> 16);
        ++this.rwIdx;
        this.payload[this.rwIdx] = (byte)(data >> 24);
        ++this.rwIdx;
        this.payload[this.rwIdx] = (byte)(data >> 32);
        ++this.rwIdx;
        this.payload[this.rwIdx] = (byte)(data >> 40);
        ++this.rwIdx;
        this.payload[this.rwIdx] = (byte)(data >> 48);
        ++this.rwIdx;
        this.payload[this.rwIdx] = (byte)(data >> 56);
        ++this.rwIdx;
        return this;
    }

    @Override
    public RainbowRPCBuf writeShort(short data) {
        this.payload[this.rwIdx] = (byte)(data >> 0);
        ++this.rwIdx;
        this.payload[this.rwIdx] = (byte)(data >> 8);
        ++this.rwIdx;
        return this;
    }

    @Override
    public int readInt() {
        int a = (this.payload[this.rIdx + 0] & 0xFF) << 0 | (this.payload[this.rIdx + 1] & 0xFF) << 8 | (this.payload[this.rIdx + 2] & 0xFF) << 16 | (this.payload[this.rIdx + 3] & 0xFF) << 24;
        this.rIdx += 4;
        return a;
    }

    @Override
    public boolean readBool() {
        int a = (this.payload[this.rIdx + 0] & 0xFF) << 0;
        ++this.rIdx;
        return a == 1;
    }

    @Override
    public byte readByte() {
        byte a = (byte)((this.payload[this.rIdx + 0] & 0xFF) << 0);
        ++this.rIdx;
        return a;
    }

    @Override
    public void readBytes(byte[] readContainer) {
        int len = readContainer.length;
        for (int i = 0; i < len; ++i) {
            readContainer[i] = (byte)((this.payload[this.rIdx + i] & 0xFF) << 0);
        }
    }

    @Override
    public long readLong() {
        int a = (this.payload[this.rIdx + 0] & 0xFF) << 0 | (this.payload[this.rIdx + 1] & 0xFF) << 8 | (this.payload[this.rIdx + 2] & 0xFF) << 16 | (this.payload[this.rIdx + 3] & 0xFF) << 24 | (this.payload[this.rIdx + 3] & 0xFF) << 32 | (this.payload[this.rIdx + 3] & 0xFF) << 40 | (this.payload[this.rIdx + 3] & 0xFF) << 48 | (this.payload[this.rIdx + 3] & 0xFF) << 56;
        this.rIdx += 8;
        return a;
    }

    @Override
    public short readShort() {
        int a = (this.payload[this.rIdx + 0] & 0xFF) << 0 | (this.payload[this.rIdx + 1] & 0xFF) << 8;
        this.rIdx += 2;
        return (short)a;
    }

    @Override
    public void clear() {
        this.payload = new byte[0];
        this.rIdx = 0;
        this.rwIdx = 0;
    }

    @Override
    public byte[] toByteArray() {
        return this.payload;
    }

    @Override
    public byte[] readRemain() {
        byte[] bytes = new byte[this.payload.length - this.rIdx];
        this.readBytes(bytes);
        return bytes;
    }
}

