/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.spi.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.spi.json.AbstractJsonProvider;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonJsonNodeJsonProvider
extends AbstractJsonProvider {
    private static final Logger logger = LoggerFactory.getLogger(JacksonJsonProvider.class);
    private static final ObjectMapper defaultObjectMapper = new ObjectMapper();
    protected ObjectMapper objectMapper;

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public JacksonJsonNodeJsonProvider() {
        this(defaultObjectMapper);
    }

    public JacksonJsonNodeJsonProvider(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public Object parse(String json) throws InvalidJsonException {
        try {
            return this.objectMapper.readTree(json);
        }
        catch (IOException e) {
            logger.debug("Invalid JSON: \n" + json);
            throw new InvalidJsonException(e);
        }
    }

    @Override
    public Object parse(InputStream jsonStream, String charset) throws InvalidJsonException {
        try {
            return this.objectMapper.readTree((Reader)new InputStreamReader(jsonStream, charset));
        }
        catch (IOException e) {
            throw new InvalidJsonException(e);
        }
    }

    @Override
    public String toJson(Object obj) {
        if (!(obj instanceof JsonNode)) {
            throw new JsonPathException("Not a JSON Node");
        }
        return obj.toString();
    }

    @Override
    public Object createArray() {
        return JsonNodeFactory.instance.arrayNode();
    }

    @Override
    public Object createMap() {
        return JsonNodeFactory.instance.objectNode();
    }

    @Override
    public Object unwrap(Object o) {
        if (o == null) {
            return null;
        }
        if (!(o instanceof JsonNode)) {
            return o;
        }
        JsonNode e = (JsonNode)o;
        if (e.isValueNode()) {
            if (e.isTextual()) {
                return e.asText();
            }
            if (e.isBoolean()) {
                return e.asBoolean();
            }
            if (e.isInt()) {
                return e.asInt();
            }
            if (e.isLong()) {
                return e.asLong();
            }
            if (e.isBigDecimal()) {
                return e.decimalValue();
            }
            if (e.isDouble()) {
                return e.doubleValue();
            }
            if (e.isFloat()) {
                return Float.valueOf(e.floatValue());
            }
            if (e.isBigDecimal()) {
                return e.decimalValue();
            }
            if (e.isNull()) {
                return null;
            }
        }
        return o;
    }

    @Override
    public boolean isArray(Object obj) {
        return obj instanceof ArrayNode || obj instanceof List;
    }

    @Override
    public Object getArrayIndex(Object obj, int idx) {
        return this.toJsonArray(obj).get(idx);
    }

    @Override
    public void setArrayIndex(Object array, int index, Object newValue) {
        if (!this.isArray(array)) {
            throw new UnsupportedOperationException();
        }
        this.toJsonArray(array).insert(index, this.createJsonElement(newValue));
    }

    @Override
    public Object getMapValue(Object obj, String key) {
        ObjectNode jsonObject = this.toJsonObject(obj);
        JsonNode o = jsonObject.get(key);
        if (!jsonObject.has(key)) {
            return UNDEFINED;
        }
        return this.unwrap(o);
    }

    @Override
    public void setProperty(Object obj, Object key, Object value) {
        if (this.isMap(obj)) {
            this.toJsonObject(obj).put(key.toString(), this.createJsonElement(value));
        } else {
            ArrayNode array;
            int index = key != null ? (key instanceof Integer ? (Integer)key : Integer.parseInt(key.toString())) : array.size();
            if (index == (array = this.toJsonArray(obj)).size()) {
                array.add(this.createJsonElement(value));
            } else {
                array.set(index, this.createJsonElement(value));
            }
        }
    }

    @Override
    public void removeProperty(Object obj, Object key) {
        if (this.isMap(obj)) {
            this.toJsonObject(obj).remove(key.toString());
        } else {
            ArrayNode array = this.toJsonArray(obj);
            int index = key instanceof Integer ? (Integer)key : Integer.parseInt(key.toString());
            array.remove(index);
        }
    }

    @Override
    public boolean isMap(Object obj) {
        return obj instanceof ObjectNode;
    }

    @Override
    public Collection<String> getPropertyKeys(Object obj) {
        ArrayList<String> keys = new ArrayList<String>();
        Iterator iter = this.toJsonObject(obj).fieldNames();
        while (iter.hasNext()) {
            keys.add((String)iter.next());
        }
        return keys;
    }

    @Override
    public int length(Object obj) {
        if (this.isArray(obj)) {
            return this.toJsonArray(obj).size();
        }
        if (this.isMap(obj)) {
            return this.toJsonObject(obj).size();
        }
        if (obj instanceof TextNode) {
            TextNode element = (TextNode)obj;
            return element.size();
        }
        throw new JsonPathException("length operation can not applied to " + obj != null ? obj.getClass().getName() : "null");
    }

    @Override
    public Iterable<?> toIterable(Object obj) {
        if (this.isArray(obj)) {
            ArrayNode arr = this.toJsonArray(obj);
            ArrayList<Object> values = new ArrayList<Object>(arr.size());
            for (Object o : arr) {
                values.add(this.unwrap(o));
            }
            return values;
        }
        ArrayList<Object> values = new ArrayList<Object>();
        Iterator iter = this.toJsonObject(obj).elements();
        while (iter.hasNext()) {
            values.add(this.unwrap(iter.next()));
        }
        return values;
    }

    private JsonNode createJsonElement(Object o) {
        return this.objectMapper.valueToTree(o);
    }

    private ArrayNode toJsonArray(Object o) {
        return (ArrayNode)o;
    }

    private ObjectNode toJsonObject(Object o) {
        return (ObjectNode)o;
    }
}

