/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.test;

import com.alibaba.druid.pool.DruidDataSource;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.beetl.sql.core.ClasspathLoader;
import org.beetl.sql.core.ConnectionSource;
import org.beetl.sql.core.ConnectionSourceHelper;
import org.beetl.sql.core.Interceptor;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.UnderlinedNameConversion;
import org.beetl.sql.core.db.MySqlStyle;
import org.beetl.sql.ext.DebugInterceptor;
import org.beetl.sql.test.MysqlDBConfig;
import org.beetl.sql.test.User;

public class QuickTest {
    public static void main(String[] args) throws Exception {
        MySqlStyle style = new MySqlStyle();
        ConnectionSource cs = ConnectionSourceHelper.getSingle(QuickTest.datasource());
        ClasspathLoader loader = new ClasspathLoader("/org/beetl/sql/test");
        DebugInterceptor debug = new DebugInterceptor(QuickTest.class.getName());
        Interceptor[] inters = new Interceptor[]{debug};
        SQLManager sql = new SQLManager(style, loader, cs, new UnderlinedNameConversion(), inters);
    }

    public static User unique(SQLManager sql, Object key) {
        return sql.unique(User.class, key);
    }

    public static DataSource datasource() {
        HikariDataSource ds = new HikariDataSource();
        ds.setJdbcUrl(MysqlDBConfig.url);
        ds.setUsername(MysqlDBConfig.userName);
        ds.setPassword(MysqlDBConfig.password);
        ds.setDriverClassName(MysqlDBConfig.driver);
        return ds;
    }

    public static DataSource druidSource() {
        DruidDataSource ds = new DruidDataSource();
        ds.setUrl(MysqlDBConfig.url);
        ds.setUsername(MysqlDBConfig.userName);
        ds.setPassword(MysqlDBConfig.password);
        ds.setDriverClassName(MysqlDBConfig.driver);
        return ds;
    }
}

