/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.test;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.engine.SQLParameter;
import org.beetl.sql.core.kit.EnumKit;
import org.beetl.sql.core.mapping.BeanProcessor;
import org.beetl.sql.core.mapping.type.JavaSqlTypeHandler;
import org.beetl.sql.core.mapping.type.TypeParameter;

public class MyBeanProcessor
extends BeanProcessor {
    public MyBeanProcessor(SQLManager sm) {
        super(sm);
        this.handlers.put(LocalDateTime.class, new JavaSqlTypeHandler(){

            @Override
            public Object getValue(TypeParameter typePara) throws SQLException {
                Timestamp ts = typePara.getRs().getTimestamp(typePara.getIndex());
                return ts == null ? null : ts.toLocalDateTime();
            }
        });
    }

    @Override
    public void setPreparedStatementPara(String sqlId, PreparedStatement ps, List<SQLParameter> objs) throws SQLException {
        for (int i = 0; i < objs.size(); ++i) {
            int jdbcType;
            SQLParameter para = objs.get(i);
            Object o = para.value;
            if (o == null) {
                ps.setObject(i + 1, o);
                continue;
            }
            Class<?> c = o.getClass();
            if (c == LocalDateTime.class) {
                LocalDateTime d = (LocalDateTime)o;
                ps.setTimestamp(i + 1, Timestamp.valueOf(d));
                continue;
            }
            if ((this.dbType == 2 || this.dbType == 3 || this.dbType == 6) && c == Date.class) {
                o = new Timestamp(((Date)o).getTime());
            }
            if (Enum.class.isAssignableFrom(c)) {
                o = EnumKit.getValueByEnum(o);
            }
            if (c == char[].class) {
                o = new String((char[])o);
            }
            if ((jdbcType = para.getJdbcType()) == 0) {
                ps.setObject(i + 1, o);
                continue;
            }
            throw new UnsupportedOperationException(jdbcType + ",\u9ed8\u8ba4\u5904\u7406\u5668\u5e76\u672a\u5904\u7406\u6b64jdbc\u7c7b\u578b");
        }
    }
}

