/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.mapper;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beetl.sql.core.BeetlSQLException;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.SQLScript;
import org.beetl.sql.core.annotatoin.Sql;
import org.beetl.sql.core.annotatoin.SqlStatement;
import org.beetl.sql.core.annotatoin.SqlStatementType;
import org.beetl.sql.core.db.KeyHolder;
import org.beetl.sql.core.engine.PageQuery;
import org.beetl.sql.core.mapper.para.InsertParamter;
import org.beetl.sql.core.mapper.para.MapperParameter;
import org.beetl.sql.core.mapper.para.PageQueryParamter;
import org.beetl.sql.core.mapper.para.SelectQueryParamter;
import org.beetl.sql.core.mapper.para.UpdateParamter;

public class MethodDesc {
    public static final int SM_INSERT = 0;
    public static final int SM_INSERT_KEYHOLDER = 1;
    public static final int SM_SELECT_SINGLE = 2;
    public static final int SM_SELECT_LIST = 3;
    public static final int SM_UPDATE = 4;
    public static final int SM_BATCH_UPDATE = 5;
    public static final int SM_PAGE_QUERY = 6;
    public static final int SM_SQL_READY_PAGE_QUERY = 7;
    public int type = 0;
    public String sqlReady = "";
    public Class resultType = Void.class;
    public MapperParameter parameter = null;
    public String paramsDeclare = null;
    private Method method = null;
    static Map<CallKey, MethodDesc> cache = new HashMap<CallKey, MethodDesc>();

    public static MethodDesc getMetodDesc(SQLManager sm, Class entityClass, Method m, String sqlId) {
        CallKey callKey = new CallKey(m, entityClass);
        MethodDesc desc = cache.get(callKey);
        if (desc != null) {
            return desc;
        }
        desc = sm.getMapperConfig().createMethodDesc();
        desc.doParse(sm, entityClass, m, sqlId);
        cache.put(callKey, desc);
        return desc;
    }

    protected void doParse(SQLManager sm, Class entityClass, Method m, String sqlId) {
        Class[] paras = m.getParameterTypes();
        Type retType = m.getGenericReturnType();
        this.resultType = entityClass;
        this.method = m;
        Sql sql = m.getAnnotation(Sql.class);
        SqlStatementType sqlType = SqlStatementType.AUTO;
        if (sql != null) {
            this.sqlReady = sql.value();
            sqlType = sql.type();
            if (sql.returnType() != Void.class) {
                this.resultType = sql.returnType();
            }
        } else {
            SqlStatement st = m.getAnnotation(SqlStatement.class);
            if (st != null) {
                sqlType = st.type();
                this.paramsDeclare = st.params();
                if (st.returnType() != Void.class) {
                    this.resultType = st.returnType();
                }
            }
        }
        int inferType = 0;
        if (sqlType == SqlStatementType.AUTO) {
            inferType = sql != null ? this.getTypeBySql(this.sqlReady) : this.getTypeBySqlId(sm, sqlId);
            if (inferType == -1) {
                throw new BeetlSQLException(10, sqlId + " \u8bf7\u6307\u5b9aSql\u7c7b\u578b");
            }
        } else {
            inferType = sqlType == SqlStatementType.SELECT ? 3 : (sqlType == SqlStatementType.INSERT ? 0 : 4);
        }
        this.type = inferType;
        switch (this.type) {
            case 3: {
                this.parseSelectList(paras, retType);
                break;
            }
            case 0: {
                this.parseInert(paras, retType);
                break;
            }
            case 4: {
                this.parseUpdate(paras, retType);
            }
        }
    }

    protected void parseInert(Class[] paras, Type retType) {
        this.type = retType == KeyHolder.class ? 1 : 0;
        this.parameter = new InsertParamter(this.method, this.paramsDeclare);
    }

    protected void parseUpdate(Class[] paras, Type retType) {
        this.parameter = new UpdateParamter(this.method, this.paramsDeclare);
        this.type = 4;
        Class<?> ret = this.method.getReturnType();
        if (this.isInt(ret)) {
            return;
        }
        if (ret.isArray()) {
            Class<?> type = ret.getComponentType();
            if (type == Integer.TYPE || type == Long.TYPE || type == Short.TYPE || type == Integer.class || type == Short.class || type == Long.class) {
                this.type = 5;
            }
            return;
        }
        if (paras.length == 1) {
            Class<?> ct;
            Class first = paras[0];
            if (List.class.isAssignableFrom(first) && this.isUpdateBatchByFirstList()) {
                this.type = 5;
            } else if (first.isArray() && this.isPojo(ct = first.getComponentType())) {
                this.type = 5;
            }
        }
    }

    private boolean isUpdateBatchByFirstList() {
        Type firstType = this.method.getGenericParameterTypes()[0];
        Class type = this.getType(firstType);
        if (type == null) {
            return true;
        }
        return this.isPojo(type);
    }

    private boolean isPojo(Class type) {
        if (type.isPrimitive()) {
            return false;
        }
        if (Map.class.isAssignableFrom(type)) {
            return true;
        }
        String pkg = type.getPackage().getName();
        return !pkg.startsWith("java.") && !pkg.startsWith("javax.");
    }

    private boolean isInt(Class type) {
        return type == Integer.TYPE || type == Long.TYPE || type == Short.TYPE || type == Integer.class || type == Short.class || type == Long.class;
    }

    protected void parseSelectList(Class[] paras, Type retType) {
        boolean isJdbc;
        Type pageType = this.hasPageQuery(this.method.getGenericParameterTypes(), this.method.getGenericReturnType());
        boolean bl = isJdbc = this.sqlReady.length() != 0;
        if (pageType != null) {
            this.resultType = this.getPageType(pageType, this.resultType);
            if (isJdbc) {
                this.type = 7;
                this.parameter = new PageQueryParamter(this.method, this.paramsDeclare, isJdbc);
            } else {
                this.type = 6;
                this.parameter = new PageQueryParamter(this.method, this.paramsDeclare, isJdbc);
            }
            return;
        }
        this.parameter = new SelectQueryParamter(this.method, this.paramsDeclare, isJdbc);
        if (retType instanceof Class && Map.class.isAssignableFrom((Class)retType) || retType instanceof ParameterizedType && Map.class.isAssignableFrom(this.getParamterTypeClass(retType))) {
            this.type = 2;
            this.resultType = Map.class;
            return;
        }
        if (retType instanceof Class && List.class.isAssignableFrom((Class)retType)) {
            this.type = 3;
            return;
        }
        if (List.class.isAssignableFrom(this.getParamterTypeClass(retType))) {
            Class type = this.getType(retType);
            if (type != null) {
                this.resultType = type;
            }
            this.type = 3;
            return;
        }
        this.resultType = this.method.getReturnType();
        this.type = 2;
    }

    protected Class getPageType(Type type, Class defaultClass) {
        if (type instanceof Class) {
            return defaultClass;
        }
        Type t = ((ParameterizedType)type).getActualTypeArguments()[0];
        if (t instanceof ParameterizedType) {
            return this.getParamterTypeClass(t);
        }
        return (Class)t;
    }

    protected Class getType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            Type t = ((ParameterizedType)type).getActualTypeArguments()[0];
            if (t instanceof ParameterizedType) {
                return this.getParamterTypeClass(t);
            }
            return (Class)t;
        }
        return null;
    }

    protected Class getParamterTypeClass(Type t) {
        if (t instanceof Class) {
            return (Class)t;
        }
        return (Class)((ParameterizedType)t).getRawType();
    }

    protected Type hasPageQuery(Type[] paras, Type retType) {
        if (this.getParamterTypeClass(retType) == PageQuery.class) {
            return retType;
        }
        if (paras.length >= 1 && this.getParamterTypeClass(paras[0]) == PageQuery.class) {
            return paras[0];
        }
        return null;
    }

    private int getTypeBySql(String sql) {
        String sqlType = MethodDesc.getFirstToken(sql);
        if (sqlType.equals("select")) {
            return 3;
        }
        if (sqlType.equals("insert")) {
            return 0;
        }
        if (sqlType.equals("delete")) {
            return 4;
        }
        if (sqlType.equals("update")) {
            return 4;
        }
        if (sqlType.equals("create")) {
            return 4;
        }
        if (sqlType.equals("drop")) {
            return 4;
        }
        return -1;
    }

    private static String getFirstToken(String sql) {
        boolean start = false;
        int startIndex = 0;
        for (int i = 0; i < sql.length(); ++i) {
            char c = sql.charAt(i);
            if (!start) {
                if (MethodDesc.isSpecialChar(c)) continue;
                start = true;
                startIndex = i;
                continue;
            }
            if (!MethodDesc.isSpecialChar(c)) continue;
            return sql.substring(startIndex, i).toLowerCase();
        }
        return "";
    }

    private static boolean isSpecialChar(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    protected int getTypeBySqlId(SQLManager sm, String sqlId) {
        String sql = null;
        SQLScript script = sm.getScript(sqlId);
        sql = script.getSql();
        int ret = this.getTypeBySql(sql);
        if (ret == -1) {
            throw new BeetlSQLException(10, sqlId + " \u8bf7\u6307\u5b9aSql\u7c7b\u578b");
        }
        return ret;
    }

    protected Class getRetType(Method method, Class entityClass) {
        Type type = method.getGenericReturnType();
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)method.getGenericReturnType()).getActualTypeArguments()[0];
        }
        return entityClass;
    }

    static class CallKey {
        Method m;
        Class entityClass;

        public CallKey(Method m, Class entityClass) {
            this.m = m;
            this.entityClass = entityClass;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.entityClass == null ? 0 : this.entityClass.hashCode());
            result = 31 * result + (this.m == null ? 0 : this.m.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            CallKey other = (CallKey)obj;
            return other.entityClass == this.entityClass && this.m.equals(other.m);
        }
    }
}

