/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.orm;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.SQLReady;
import org.beetl.sql.core.Tail;
import org.beetl.sql.core.db.ClassDesc;
import org.beetl.sql.core.db.TableDesc;
import org.beetl.sql.core.kit.BeanKit;
import org.beetl.sql.core.kit.CaseInsensitiveOrderSet;
import org.beetl.sql.core.kit.StringKit;

public class MappingEntity
implements Serializable {
    protected String target;
    protected boolean isSingle = false;
    protected Map<String, String> mapkey;
    protected String sqlId = null;
    protected Map<String, Object> queryParas = null;
    protected String tailName;
    protected boolean absentPackage = false;
    protected Class targetClass = null;
    Map<String, List> cache = new HashMap<String, List>();

    public void map(Object o, SQLManager sm) {
        this.map(Arrays.asList(o), sm);
    }

    public void map(List list, SQLManager sm) {
        if (list.size() == 0) {
            return;
        }
        this.init(list.get(0));
        if (this.mapkey.size() == 1) {
            String tableName = sm.getNc().getTableName(this.targetClass);
            TableDesc tableDesc = sm.getMetaDataManager().getTable(tableName);
            ClassDesc classDesc = tableDesc.getClassDesc(this.targetClass, sm.getNc());
            if (classDesc.getIdAttrs().size() == 1 && classDesc.getIdAttrs().containsAll(this.mapkey.values())) {
                this.allInOneQuery(list, tableDesc, classDesc, sm);
                return;
            }
        }
        for (Object obj : list) {
            this.mapClassItem(obj, sm);
        }
    }

    private void allInOneQuery(List list, TableDesc tableDesc, ClassDesc classDesc, SQLManager sm) {
        String idAttr = classDesc.getIdAttrs().get(0);
        String idCol = ((CaseInsensitiveOrderSet)tableDesc.getIdNames()).getFirst();
        StringBuilder sb = new StringBuilder();
        sb.append("select * from ").append(tableDesc.getSchema() == null ? "" : tableDesc.getSchema() + ".").append(tableDesc.getName()).append(" where ").append(idCol).append(" in (");
        HashSet<Object> idValues = new HashSet<Object>(list.size());
        String foreignAttr = this.mapkey.keySet().iterator().next();
        for (Object e : list) {
            Object id = BeanKit.getBeanProperty(e, foreignAttr);
            idValues.add(id);
        }
        for (Object e : idValues) {
            sb.append("?,");
        }
        sb.setLength(sb.length() - 1);
        sb.append(")");
        SQLReady ready = new SQLReady(sb.toString(), idValues.toArray());
        List list2 = sm.execute(ready, this.targetClass);
        HashMap mapRets = new HashMap();
        for (Object ret : list2) {
            Object id = BeanKit.getBeanProperty(ret, idAttr);
            mapRets.put(id, ret);
        }
        for (Object o : list) {
            Object foreignId = BeanKit.getBeanProperty(o, foreignAttr);
            Object ref = mapRets.get(foreignId);
            if (this.isSingle) {
                this.setTailAttr(o, ref);
                continue;
            }
            ArrayList listRet = new ArrayList(1);
            listRet.add(ref);
            this.setTailAttr(o, listRet);
        }
    }

    protected void init(Object obj) {
        if (this.target.indexOf(".") == -1) {
            this.absentPackage = true;
        }
        if (this.tailName == null) {
            if (this.target.indexOf(".") == -1) {
                this.tailName = StringKit.toLowerCaseFirstOne(this.target);
            } else {
                int index = this.target.lastIndexOf(".");
                String className = this.target.substring(index + 1);
                this.tailName = StringKit.toLowerCaseFirstOne(className);
            }
        }
        String fullName = this.absentPackage ? obj.getClass().getPackage().getName() + "." + this.target : this.target;
        this.targetClass = this.getCls(fullName);
    }

    protected void mapClassItem(Object obj, SQLManager sm) {
        List ret = null;
        StringBuilder key = new StringBuilder();
        if (this.sqlId != null) {
            HashMap<String, Object> paras = new HashMap<String, Object>();
            for (Map.Entry<String, String> entry : this.mapkey.entrySet()) {
                String attr = entry.getKey();
                String targetAttr = entry.getValue();
                Object value = BeanKit.getBeanProperty(obj, attr);
                paras.put(targetAttr, value);
                key.append(value).append("_");
            }
            String cacheKey = key.toString();
            if (this.cache.containsKey(cacheKey)) {
                ret = this.cache.get(cacheKey);
            } else {
                ret = sm.select(this.sqlId, this.targetClass, paras);
                this.cache.put(cacheKey, ret);
            }
        } else {
            Object ins = this.getIns(this.targetClass);
            for (Map.Entry<String, String> entry : this.mapkey.entrySet()) {
                String attr = entry.getKey();
                String targetAttr = entry.getValue();
                Object value = BeanKit.getBeanProperty(obj, attr);
                BeanKit.setBeanProperty(ins, value, targetAttr);
                key.append(value).append("_");
            }
            String cacheKey = key.toString();
            if (this.cache.containsKey(cacheKey)) {
                ret = this.cache.get(cacheKey);
            } else {
                ret = sm.template(ins);
                this.cache.put(cacheKey, ret);
            }
        }
        if (this.isSingle) {
            if (ret.isEmpty()) {
                this.setTailAttr(obj, null);
            } else {
                this.setTailAttr(obj, ret.get(0));
            }
        } else {
            this.setTailAttr(obj, ret);
        }
    }

    protected void setTailAttr(Object o, Object value) {
        if (o instanceof Tail) {
            ((Tail)o).set(this.tailName, value);
        } else {
            Method m = BeanKit.getTailMethod(o.getClass());
            if (m == null) {
                throw new RuntimeException("must implement tail or use @tail");
            }
            try {
                m.invoke(o, this.tailName, value);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    protected Object getIns(Class cls) {
        try {
            return cls.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected Class getCls(String fullName) {
        Class<?> cls = null;
        try {
            cls = Class.forName(fullName);
            return cls;
        }
        catch (Exception ex) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader != null) {
                try {
                    cls = loader.loadClass(fullName);
                    return cls;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            throw new RuntimeException(ex);
        }
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public boolean isSingle() {
        return this.isSingle;
    }

    public void setSingle(boolean isSingle) {
        this.isSingle = isSingle;
    }

    public Map<String, String> getMapkey() {
        return this.mapkey;
    }

    public void setMapkey(Map<String, String> mapkey) {
        this.mapkey = mapkey;
    }

    public String getSqlId() {
        return this.sqlId;
    }

    public void setSqlId(String sqlId) {
        this.sqlId = sqlId;
    }

    public String getTailName() {
        return this.tailName;
    }

    public void setTailName(String tailName) {
        this.tailName = tailName;
    }

    public Map<String, Object> getQueryParas() {
        return this.queryParas;
    }

    public void setQueryParas(Map<String, Object> queryParas) {
        this.queryParas = queryParas;
    }
}

