/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.mapper;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.annotatoin.SqlResource;
import org.beetl.sql.core.mapper.DefaultMapperBuilder;
import org.beetl.sql.core.mapper.MapperInvoke;
import org.beetl.sql.core.mapper.MethodDesc;
import org.beetl.sql.core.mapper.builder.MapperConfig;
import org.beetl.sql.core.mapper.builder.MapperInvokeDataConfig;

public class MapperJavaProxy
implements InvocationHandler {
    protected SQLManager sqlManager;
    protected Class<?> entityClass;
    protected DefaultMapperBuilder builder;
    protected MapperConfig mapperConfig;

    public MapperJavaProxy() {
    }

    public MapperJavaProxy(DefaultMapperBuilder builder, SQLManager sqlManager, Class<?> mapperInterface) {
        this.sqlManager = sqlManager;
        this.builder = builder;
        this.mapperInterface(mapperInterface);
    }

    public MapperJavaProxy mapperInterface(Class<?> mapperInterface) {
        this.onResolveEntityClassFromMapperInterface(mapperInterface);
        return this;
    }

    public MapperJavaProxy entityClass(Class<?> entityClass) {
        this.entityClass = entityClass;
        return this;
    }

    protected void checkArgs() {
    }

    public MapperJavaProxy build() {
        this.checkArgs();
        return this;
    }

    protected void onResolveEntityClassFromMapperInterface(Class<?> mapperInterface) {
        if (mapperInterface.isInterface()) {
            ParameterizedType pt;
            Type[] faces = mapperInterface.getGenericInterfaces();
            if (faces.length > 0 && faces[0] instanceof ParameterizedType && (pt = (ParameterizedType)faces[0]).getActualTypeArguments().length > 0) {
                this.entityClass = (Class)pt.getActualTypeArguments()[0];
            }
        } else {
            throw new IllegalArgumentException("mapperInterface is not interface.");
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> caller = method.getDeclaringClass();
        SqlResource resource = caller.getAnnotation(SqlResource.class);
        String sqlId = null;
        if (resource != null) {
            String preffix = resource.value();
            String name = method.getName();
            sqlId = preffix + "." + name;
        } else {
            sqlId = this.builder.getIdGen().getId(method.getDeclaringClass(), this.entityClass, method);
        }
        String methodName = method.getName();
        MapperInvoke invoke = this.sqlManager.getMapperConfig().getAmi(caller, methodName);
        if (invoke != null) {
            return invoke.call(this.sqlManager, this.entityClass, sqlId, method, args);
        }
        MethodDesc desc = MethodDesc.getMetodDesc(this.sqlManager, this.entityClass, method, sqlId);
        if (desc.sqlReady.length() == 0) {
            invoke = MapperInvokeDataConfig.getMethodDescProxy(desc.type);
            Object ret = invoke.call(this.sqlManager, this.entityClass, sqlId, method, args);
            return ret;
        }
        invoke = MapperInvokeDataConfig.getSQLReadyProxy();
        Object ret = invoke.call(this.sqlManager, this.entityClass, desc.sqlReady, method, args);
        return ret;
    }
}

