/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.statement;

import org.beetl.core.Context;
import org.beetl.core.InferContext;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.misc.ALU;
import org.beetl.core.statement.ASTNode;
import org.beetl.core.statement.BlockStatement;
import org.beetl.core.statement.Expression;
import org.beetl.core.statement.GrammarToken;
import org.beetl.core.statement.Statement;

public class SelectStatement
extends Statement {
    Expression value;
    Expression[] conditions;
    BlockStatement[] blocks;
    BlockStatement defaultBlock;

    public SelectStatement(Expression value, Expression[] conditions, BlockStatement[] blocks, BlockStatement defaultBlock, GrammarToken token) {
        super(token);
        this.value = value;
        this.conditions = conditions;
        this.blocks = blocks;
        this.defaultBlock = defaultBlock;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void execute(Context ctx) {
        Object base = null;
        if (this.value != null && (base = this.value.evaluate(ctx)) == null) {
            BeetlException ex = new BeetlException("NULL");
            ex.pushToken(this.value.token);
            throw ex;
        }
        boolean isMatch = false;
        for (int i = 0; i < this.conditions.length; ++i) {
            Expression exp = this.conditions[i];
            Object condValue = exp.evaluate(ctx);
            if (this.value == null) {
                if (!(condValue instanceof Boolean)) {
                    BeetlException be = new BeetlException("BOOLEAN_EXPECTED_ERROR");
                    be.pushToken(exp.token);
                    throw be;
                }
                isMatch = (Boolean)condValue;
            } else if (ALU.equals(base, condValue)) {
                isMatch = true;
            }
            if (!isMatch) continue;
            BlockStatement block = this.blocks[i];
            if (block == null) break;
            block.execute(ctx);
            break;
        }
        if (!isMatch && this.defaultBlock != null) {
            this.defaultBlock.execute(ctx);
        }
    }

    @Override
    public void infer(InferContext inferCtx) {
        if (this.value != null) {
            this.value.infer(inferCtx);
        }
        for (Expression expression : this.conditions) {
            expression.infer(inferCtx);
        }
        for (ASTNode aSTNode : this.blocks) {
            ((BlockStatement)aSTNode).infer(inferCtx);
        }
        if (this.defaultBlock != null) {
            this.defaultBlock.infer(inferCtx);
        }
    }
}

