/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class HTMLTagParser {
    int index = 0;
    char[] cs = null;
    boolean isStart;
    String tagName = null;
    boolean isEmptyTag = false;
    Map<String, String> expMap = new LinkedHashMap<String, String>();
    Map<String, Character> quatMap = new LinkedHashMap<String, Character>();
    List<String> crKey = new ArrayList<String>(1);
    boolean hasVarBinding = false;
    String varBidingStr = null;
    int status = 0;
    int ts;
    int te;
    String lastKey = null;
    String bindingAttr = null;
    static char ENT_TAG = (char)62;
    static char[] ENT_TAGS = new char[]{'/', '>'};

    public HTMLTagParser(char[] cs, int index, String bindingAttr, boolean isStart) {
        this.cs = cs;
        this.bindingAttr = bindingAttr;
        this.index = index;
        this.isStart = isStart;
        this.ts = index;
        this.te = index;
    }

    public void parser() {
        if (this.isStart) {
            this.parserStart();
        } else {
            this.parserEnd();
        }
    }

    public void parserStart() {
        this.findTagName();
        this.findAttrs();
        this.findBindingFlag();
        if (this.status != -1) {
            this.findVars();
        }
        this.endTag();
    }

    public void findTagName() {
        this.idToken();
        if (this.status == -1) {
            throw new RuntimeException("\u975e\u6cd5\u6807\u7b7e\u540d");
        }
        StringBuilder tagSb = new StringBuilder();
        tagSb.append(this.subString());
        this.t_consume();
        while (this.match(':')) {
            this.move(1);
            this.idToken();
            if (this.status == -1) {
                throw new RuntimeException("\u975e\u6cd5\u6807\u7b7e\u540d");
            }
            tagSb.append(":").append(this.subString());
            this.t_consume();
        }
        this.tagName = tagSb.toString();
    }

    public boolean match(char c) {
        return this.cs[this.index] == c;
    }

    protected boolean matchCR() {
        return this.index < this.cs.length && (this.cs[this.index] == '\r' || this.cs[this.index] == '\n');
    }

    public boolean match(char[] expected) {
        int i;
        for (i = 0; this.index + i < this.cs.length && i < expected.length; ++i) {
            if (this.cs[this.index + i] == expected[i]) continue;
            return false;
        }
        return i == expected.length;
    }

    protected void findAttrs() {
        this.findAttr();
        while (this.status != -1) {
            if (this.match(' ') || this.matchCR()) {
                this.findAttr();
                continue;
            }
            return;
        }
        this.t_recover();
    }

    protected void findAttr() {
        boolean findCR = this.stripSpaceAndCR();
        this.idToken();
        if (this.status == -1) {
            return;
        }
        this.lastKey = this.subString();
        this.t_consume();
        this.stripSpace();
        if (this.match('=')) {
            this.move(1);
            boolean isSingleQuat = this.strToken();
            String value = this.subString();
            this.t_consume();
            this.move(1);
            if (this.lastKey.equals(this.bindingAttr)) {
                this.hasVarBinding = true;
                this.varBidingStr = value;
                return;
            }
            this.quatMap.put(this.lastKey, Character.valueOf(isSingleQuat ? (char)'\'' : '\"'));
            this.expMap.put(this.lastKey, value);
            if (findCR) {
                this.crKey.add(this.lastKey);
            }
        } else {
            throw new RuntimeException("\u6ca1\u6709\u627e\u5230\u5c5e\u6027");
        }
    }

    protected void findBindingFlag() {
        this.stripSpace();
        if (!this.match(';')) {
            this.status = -1;
            return;
        }
        this.move(1);
        this.hasVarBinding = true;
    }

    protected void findVars() {
        this.stripSpace();
        this.idToken();
        StringBuilder sb = new StringBuilder();
        while (this.status != -1) {
            sb.append(this.subString());
            this.t_consume();
            this.stripSpace();
            if (!this.match(',')) break;
            this.move(1);
            this.stripSpace();
            this.idToken();
            sb.append(",");
        }
        this.t_consume();
        if (sb.length() != 0) {
            sb.setLength(sb.length());
            this.varBidingStr = sb.toString();
        }
    }

    protected void endTag() {
        this.stripSpace();
        if (this.match(ENT_TAG)) {
            this.move(1);
            this.isEmptyTag = false;
        } else if (this.match(ENT_TAGS)) {
            this.isEmptyTag = true;
            this.move(2);
        } else {
            char illegal = this.cs[this.index];
            if (illegal == '\r' || illegal == '\n') {
                throw new RuntimeException("\u6807\u7b7e\u672a\u6b63\u786e\u7ed3\u675f:" + this.tagName + ",\u78b0\u5230\u6362\u884c\u7b26\u53f7");
            }
            throw new RuntimeException("\u6807\u7b7e\u672a\u6b63\u786e\u7ed3\u675f:" + this.tagName + ",\u78b0\u5230\u975e\u6cd5\u7b26\u53f7'" + this.cs[this.index] + "'");
        }
    }

    protected boolean strToken() {
        this.stripSpace();
        if (this.match('\'')) {
            this.move(1);
            this.findOneChar('\'');
            if (this.status == -1) {
                throw new RuntimeException("\u9519\u8bef\u7684\u5c5e\u6027\uff0c\u7f3a\u5c11'");
            }
            return true;
        }
        if (this.match('\"')) {
            this.move(1);
            this.findOneChar('\"');
            if (this.status == -1) {
                throw new RuntimeException("\u9519\u8bef\u7684\u5c5e\u6027,\u7f3a\u5c11'");
            }
            return false;
        }
        throw new RuntimeException("\u5c5e\u6027\u5fc5\u987b\u4f7f\u7528\u53cc\u5f15\u53f7\u6216\u8005\u5355\u5f15\u53f7");
    }

    protected void idToken() {
        if (this.ts > this.cs.length) {
            throw new RuntimeException("\u89e3\u6790\u9519");
        }
        char c = this.cs[this.ts];
        if (this.isID(c)) {
            int i = 1;
            while (this.ts < this.cs.length && (this.isID(c = this.cs[this.ts + i]) || this.isDigit(c))) {
                ++i;
            }
            this.t_forword(i);
        } else {
            this.status = -1;
        }
    }

    protected boolean stripSpaceAndCR() {
        this.ts = this.index;
        int i = 0;
        boolean findCR = false;
        while (this.ts < this.cs.length) {
            char c = this.cs[this.ts + i];
            if (c == ' ' || c == '\t') {
                ++i;
                continue;
            }
            if (c != '\n' && c != '\r') break;
            ++i;
            findCR = true;
        }
        this.ts += i;
        this.index = this.te = this.ts;
        return findCR;
    }

    protected void stripSpace() {
        char c;
        this.ts = this.index;
        int i = 0;
        while (this.ts < this.cs.length && ((c = this.cs[this.ts + i]) == ' ' || c == '\t' || c == '\n' || c == '\r')) {
            ++i;
        }
        this.ts += i;
        this.index = this.te = this.ts;
    }

    protected void t_forword(int forward) {
        this.te = this.ts + forward;
    }

    protected void t_consume() {
        this.index = this.te;
        this.ts = this.te;
        this.status = 0;
    }

    protected void t_recover() {
        this.te = this.ts = this.index;
    }

    protected void move(int i) {
        this.index += i;
        this.ts = this.te = this.index;
        this.status = 0;
    }

    protected String subString() {
        String str = new String(this.cs, this.ts, this.te - this.ts);
        return str;
    }

    protected void findOneChar(char c) {
        int i = 0;
        while (this.ts + i < this.cs.length) {
            char ch = this.cs[this.ts + i];
            if (ch != c) {
                ++i;
                if (ch != '\n' && ch != '\r') continue;
                this.status = -1;
                this.t_recover();
                return;
            }
            this.t_forword(i);
            return;
        }
        this.status = -1;
        this.t_recover();
    }

    public void parserEnd() {
        this.findTagName();
        if (!this.match('>')) {
            throw new RuntimeException(this.tagName + "\u7ed3\u675f\u6807\u7b7e\u683c\u5f0f\u9519");
        }
        this.move(1);
    }

    private boolean isID(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_';
    }

    private boolean isDigit(char c) {
        return c > '0' && c < '9';
    }

    public boolean isEmptyTag() {
        return this.isEmptyTag;
    }

    public int getIndex() {
        return this.index;
    }

    public String getTagName() {
        return this.tagName;
    }

    public Map<String, String> getExpMap() {
        return this.expMap;
    }

    public Map<String, Character> getQuatMap() {
        return this.quatMap;
    }

    public void setExpMap(Map<String, String> expMap) {
        this.expMap = expMap;
    }

    public static void main(String[] args) {
        String input = "<#bbsListTag a='1' \nc='${ kk }' var='page,dd' >hello ${a}</#bbsListTag>";
        HTMLTagParser htmltag = new HTMLTagParser(input.toCharArray(), 2, "var", true);
        htmltag.parser();
        System.out.println(htmltag.getTagName());
        System.out.println(htmltag.getExpMap());
        System.out.println(htmltag.isEmptyTag());
        System.out.println(htmltag.hasVarBinding);
        System.out.println(htmltag.varBidingStr);
    }
}

