/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time.field;

import com.google.appengine.repackaged.org.joda.time.DurationField;
import com.google.appengine.repackaged.org.joda.time.DurationFieldType;
import java.io.Serializable;
import java.util.HashMap;

public final class UnsupportedDurationField
extends DurationField
implements Serializable {
    private static final long serialVersionUID = -6390301302770925357L;
    private static HashMap<DurationFieldType, UnsupportedDurationField> cCache;
    private final DurationFieldType iType;

    public static synchronized UnsupportedDurationField getInstance(DurationFieldType type) {
        UnsupportedDurationField field;
        if (cCache == null) {
            cCache = new HashMap(7);
            field = null;
        } else {
            field = cCache.get(type);
        }
        if (field == null) {
            field = new UnsupportedDurationField(type);
            cCache.put(type, field);
        }
        return field;
    }

    private UnsupportedDurationField(DurationFieldType type) {
        this.iType = type;
    }

    @Override
    public final DurationFieldType getType() {
        return this.iType;
    }

    @Override
    public String getName() {
        return this.iType.getName();
    }

    @Override
    public boolean isSupported() {
        return false;
    }

    @Override
    public boolean isPrecise() {
        return true;
    }

    @Override
    public int getValue(long duration) {
        throw this.unsupported();
    }

    @Override
    public long getValueAsLong(long duration) {
        throw this.unsupported();
    }

    @Override
    public int getValue(long duration, long instant) {
        throw this.unsupported();
    }

    @Override
    public long getValueAsLong(long duration, long instant) {
        throw this.unsupported();
    }

    @Override
    public long getMillis(int value) {
        throw this.unsupported();
    }

    @Override
    public long getMillis(long value) {
        throw this.unsupported();
    }

    @Override
    public long getMillis(int value, long instant) {
        throw this.unsupported();
    }

    @Override
    public long getMillis(long value, long instant) {
        throw this.unsupported();
    }

    @Override
    public long add(long instant, int value) {
        throw this.unsupported();
    }

    @Override
    public long add(long instant, long value) {
        throw this.unsupported();
    }

    @Override
    public int getDifference(long minuendInstant, long subtrahendInstant) {
        throw this.unsupported();
    }

    @Override
    public long getDifferenceAsLong(long minuendInstant, long subtrahendInstant) {
        throw this.unsupported();
    }

    @Override
    public long getUnitMillis() {
        return 0L;
    }

    @Override
    public int compareTo(DurationField durationField) {
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof UnsupportedDurationField) {
            UnsupportedDurationField other = (UnsupportedDurationField)obj;
            if (other.getName() == null) {
                return this.getName() == null;
            }
            return other.getName().equals(this.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public String toString() {
        String string = this.getName();
        return new StringBuilder(26 + String.valueOf(string).length()).append("UnsupportedDurationField[").append(string).append(']').toString();
    }

    private Object readResolve() {
        return UnsupportedDurationField.getInstance(this.iType);
    }

    private UnsupportedOperationException unsupported() {
        String string = String.valueOf(this.iType);
        return new UnsupportedOperationException(new StringBuilder(21 + String.valueOf(string).length()).append(string).append(" field is unsupported").toString());
    }
}

