/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.function.primitive.LongToCharFunction;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.CharFunction0;
import com.gs.collections.api.block.function.primitive.CharToCharFunction;
import com.gs.collections.api.block.predicate.primitive.LongCharPredicate;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableCharCollection;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableLongCharMap extends LongCharMap
{
    void clear();

    void put(long key, char value);

    void putAll(LongCharMap map);

    void removeKey(long key);

    void remove(long key);

    char removeKeyIfAbsent(long key, char value);

    char getIfAbsentPut(long key, char value);

    char getIfAbsentPut(long key, CharFunction0 function);

    char getIfAbsentPutWithKey(long key, LongToCharFunction function);

    <P> char getIfAbsentPutWith(long key, CharFunction<? super P> function, P parameter);

    char updateValue(long key, char initialValueIfAbsent, CharToCharFunction function);

    MutableLongCharMap select(LongCharPredicate predicate);

    MutableLongCharMap reject(LongCharPredicate predicate);

    MutableCharCollection select(CharPredicate predicate);

    MutableCharCollection reject(CharPredicate predicate);

    <V> MutableCollection<V> collect(CharToObjectFunction<? extends V> function);

    MutableLongCharMap withKeyValue(long key, char value);

    MutableLongCharMap withoutKey(long key);

    MutableLongCharMap withoutAllKeys(LongIterable keys);

    MutableLongCharMap asUnmodifiable();

    MutableLongCharMap asSynchronized();

    char addToValue(long key, char toBeAdded);
}
