/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.function.primitive.ByteToCharFunction;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.CharFunction0;
import com.gs.collections.api.block.function.primitive.CharToCharFunction;
import com.gs.collections.api.block.predicate.primitive.ByteCharPredicate;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableCharCollection;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableByteCharMap extends ByteCharMap
{
    void clear();

    void put(byte key, char value);

    void putAll(ByteCharMap map);

    void removeKey(byte key);

    void remove(byte key);

    char removeKeyIfAbsent(byte key, char value);

    char getIfAbsentPut(byte key, char value);

    char getIfAbsentPut(byte key, CharFunction0 function);

    char getIfAbsentPutWithKey(byte key, ByteToCharFunction function);

    <P> char getIfAbsentPutWith(byte key, CharFunction<? super P> function, P parameter);

    char updateValue(byte key, char initialValueIfAbsent, CharToCharFunction function);

    MutableByteCharMap select(ByteCharPredicate predicate);

    MutableByteCharMap reject(ByteCharPredicate predicate);

    MutableCharCollection select(CharPredicate predicate);

    MutableCharCollection reject(CharPredicate predicate);

    <V> MutableCollection<V> collect(CharToObjectFunction<? extends V> function);

    MutableByteCharMap withKeyValue(byte key, char value);

    MutableByteCharMap withoutKey(byte key);

    MutableByteCharMap withoutAllKeys(ByteIterable keys);

    MutableByteCharMap asUnmodifiable();

    MutableByteCharMap asSynchronized();

    char addToValue(byte key, char toBeAdded);
}
