/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.collection.primitive;

import java.util.Collection;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;

/**
 * This file was automatically generated from template file mutablePrimitiveCollection.stg.
 *
 * @since 3.0.
 */
public interface MutableDoubleCollection extends DoubleIterable
{
    boolean add(double element);

    boolean addAll(double... source);

    boolean addAll(DoubleIterable source);

    boolean remove(double value);

    boolean removeAll(DoubleIterable source);

    boolean removeAll(double... source);

    /**
     * @see Collection#retainAll(Collection)
     * @since 5.0
     */
    boolean retainAll(DoubleIterable elements);

    /**
     * @see Collection#retainAll(Collection)
     * @since 5.0
     */
    boolean retainAll(double... source);

    void clear();

    MutableDoubleCollection select(DoublePredicate predicate);

    MutableDoubleCollection reject(DoublePredicate predicate);

    <V> MutableCollection<V> collect(DoubleToObjectFunction<? extends V> function);

    MutableDoubleCollection with(double element);

    MutableDoubleCollection without(double element);

    MutableDoubleCollection withAll(DoubleIterable elements);

    MutableDoubleCollection withoutAll(DoubleIterable elements);

    MutableDoubleCollection asUnmodifiable();

    MutableDoubleCollection asSynchronized();

    ImmutableDoubleCollection toImmutable();
}
