/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.bag.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.bag.MutableBag;

/**
 * This file was automatically generated from template file mutablePrimitiveBag.stg.
 *
 * @since 3.0.
 */
public interface MutableIntBag extends MutableIntCollection, IntBag
{
    void addOccurrences(int item, int occurrences);

    boolean removeOccurrences(int item, int occurrences);

    MutableIntBag select(IntPredicate predicate);

    MutableIntBag reject(IntPredicate predicate);

    <V> MutableBag<V> collect(IntToObjectFunction<? extends V> function);

    MutableIntBag with(int element);

    MutableIntBag without(int element);

    MutableIntBag withAll(IntIterable elements);

    MutableIntBag withoutAll(IntIterable elements);

    MutableIntBag asUnmodifiable();

    MutableIntBag asSynchronized();

    /**
     * Returns an immutable copy of this bag.
     */
    ImmutableIntBag toImmutable();
}
