/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.bag.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.api.bag.MutableBag;

/**
 * This file was automatically generated from template file mutablePrimitiveBag.stg.
 *
 * @since 3.0.
 */
public interface MutableDoubleBag extends MutableDoubleCollection, DoubleBag
{
    void addOccurrences(double item, int occurrences);

    boolean removeOccurrences(double item, int occurrences);

    MutableDoubleBag select(DoublePredicate predicate);

    MutableDoubleBag reject(DoublePredicate predicate);

    <V> MutableBag<V> collect(DoubleToObjectFunction<? extends V> function);

    MutableDoubleBag with(double element);

    MutableDoubleBag without(double element);

    MutableDoubleBag withAll(DoubleIterable elements);

    MutableDoubleBag withoutAll(DoubleIterable elements);

    MutableDoubleBag asUnmodifiable();

    MutableDoubleBag asSynchronized();

    /**
     * Returns an immutable copy of this bag.
     */
    ImmutableDoubleBag toImmutable();
}
