/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.http.impl.auth;

import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import wiremock.org.apache.http.Header;
import wiremock.org.apache.http.HttpRequest;
import wiremock.org.apache.http.annotation.NotThreadSafe;
import wiremock.org.apache.http.auth.AuthenticationException;
import wiremock.org.apache.http.auth.Credentials;
import wiremock.org.apache.http.impl.auth.GGSSchemeBase;
import wiremock.org.apache.http.protocol.HttpContext;
import wiremock.org.apache.http.util.Args;

@NotThreadSafe
public class SPNegoScheme
extends GGSSchemeBase {
    private static final String SPNEGO_OID = "1.3.6.1.5.5.2";

    public SPNegoScheme(boolean stripPort) {
        super(stripPort);
    }

    public SPNegoScheme() {
        super(false);
    }

    public String getSchemeName() {
        return "Negotiate";
    }

    public Header authenticate(Credentials credentials, HttpRequest request, HttpContext context) throws AuthenticationException {
        return super.authenticate(credentials, request, context);
    }

    protected byte[] generateToken(byte[] input, String authServer) throws GSSException {
        return this.generateGSSToken(input, new Oid(SPNEGO_OID), authServer);
    }

    public String getParameter(String name) {
        Args.notNull(name, "Parameter name");
        return null;
    }

    public String getRealm() {
        return null;
    }

    public boolean isConnectionBased() {
        return true;
    }
}

