/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template;

import java.nio.charset.Charset;
import java.util.List;
import java.util.Properties;
import jetbrick.config.Config;
import jetbrick.config.ConfigLoader;
import jetbrick.template.JetSecurityManager;
import jetbrick.template.loader.ClasspathResourceLoader;
import jetbrick.template.loader.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JetConfig {
    public static final String DEFAULT_CONFIG_FILE = "classpath:/jetbrick-template.properties";
    public static final String IMPORT_CLASSES = "jetx.import.classes";
    public static final String IMPORT_METHODS = "jetx.import.methods";
    public static final String IMPORT_FUNCTIONS = "jetx.import.functions";
    public static final String IMPORT_TAGS = "jetx.import.tags";
    public static final String IMPORT_MACROS = "jetx.import.macros";
    public static final String IMPORT_DEFINES = "jetx.import.defines";
    public static final String AUTOSCAN_PACKAGES = "jetx.autoscan.packages";
    public static final String AUTOSCAN_SKIPERRORS = "jetx.autoscan.skiperrors";
    public static final String TEMPLATE_LOADERS = "jetx.template.loaders";
    public static final String TEMPLATE_SUFFIX = "jetx.template.suffix";
    public static final String TEMPLATE_SOURCE_SECURITYMANAGER = "jetx.template.source.securityManager";
    public static final String INPUT_ENCODING = "jetx.input.encoding";
    public static final String OUTPUT_ENCODING = "jetx.output.encoding";
    public static final String SYNTAX_STRICT = "jetx.syntax.strict";
    public static final String SYNTAX_SAFECALL = "jetx.syntax.safecall";
    public static final String TRIM_LEADING_WHITESPACES = "jetx.trim.leading.whitespaces";
    public static final String TRIM_DIRECTIVE_WHITESPACES = "jetx.trim.directive.whitespaces";
    public static final String TRIM_DIRECTIVE_COMMENTS = "jetx.trim.directive.comments";
    public static final String TRIM_DIRECTIVE_COMMENTS_PREFIX = "jetx.trim.directive.comments.prefix";
    public static final String TRIM_DIRECTIVE_COMMENTS_SUFFIX = "jetx.trim.directive.comments.suffix";
    public static final String IO_SKIPERRORS = "jetx.io.skiperrors";
    private final Logger log = LoggerFactory.getLogger(JetConfig.class);
    private List<String> importClasses;
    private List<String> importMethods;
    private List<String> importFunctions;
    private List<String> importTags;
    private List<String> importMacros;
    private List<String> importDefines;
    private List<String> autoscanPackages;
    private boolean autoscanSkiperrors;
    private List<ResourceLoader> templateLoaders;
    private String templateSuffix;
    private JetSecurityManager templateSecurityManager;
    private Charset inputEncoding;
    private Charset outputEncoding;
    private boolean syntaxStrict;
    private boolean syntaxSafecall;
    private boolean trimLeadingWhitespaces;
    private boolean trimDirectiveWhitespaces;
    private boolean trimDirectiveComments;
    private String trimDirectiveCommentsPrefix;
    private String trimDirectiveCommentsSuffix;
    private boolean ioSkiperrors;

    protected JetConfig(Properties config, String configLocation) {
        ConfigLoader loader = new ConfigLoader();
        if (config != null) {
            loader.load(config);
        }
        if (configLocation != null) {
            try {
                this.log.info("Loading config file: {}", (Object)configLocation);
                loader.load(configLocation);
            }
            catch (IllegalStateException e) {
                if (!DEFAULT_CONFIG_FILE.equals(configLocation)) {
                    throw e;
                }
                this.log.warn("no default config file found: {}", (Object)DEFAULT_CONFIG_FILE);
            }
        }
        this.initialize(loader.asConfig());
    }

    private void initialize(Config config) {
        this.importClasses = config.asStringList(IMPORT_CLASSES);
        this.importMethods = config.asStringList(IMPORT_METHODS);
        this.importFunctions = config.asStringList(IMPORT_FUNCTIONS);
        this.importTags = config.asStringList(IMPORT_TAGS);
        this.importMacros = config.asStringList(IMPORT_MACROS);
        this.importDefines = config.asStringList(IMPORT_DEFINES);
        this.autoscanPackages = config.asStringList(AUTOSCAN_PACKAGES);
        this.autoscanSkiperrors = config.asBoolean(AUTOSCAN_SKIPERRORS, "false");
        this.templateLoaders = config.asObjectList(TEMPLATE_LOADERS, ResourceLoader.class, ClasspathResourceLoader.class.getName());
        this.templateSuffix = config.asString(TEMPLATE_SUFFIX, ".jetx");
        this.templateSecurityManager = (JetSecurityManager)config.asObject(TEMPLATE_SOURCE_SECURITYMANAGER, JetSecurityManager.class);
        this.inputEncoding = config.asCharset(INPUT_ENCODING, "utf-8");
        this.outputEncoding = config.asCharset(OUTPUT_ENCODING, "utf-8");
        this.syntaxStrict = config.asBoolean(SYNTAX_STRICT, "false");
        this.syntaxSafecall = config.asBoolean(SYNTAX_SAFECALL, "false");
        this.trimLeadingWhitespaces = config.asBoolean(TRIM_LEADING_WHITESPACES, "false");
        this.trimDirectiveWhitespaces = config.asBoolean(TRIM_DIRECTIVE_WHITESPACES, "true");
        this.trimDirectiveComments = config.asBoolean(TRIM_DIRECTIVE_COMMENTS, "false");
        this.trimDirectiveCommentsPrefix = config.asString(TRIM_DIRECTIVE_COMMENTS_PREFIX, "<!--");
        this.trimDirectiveCommentsSuffix = config.asString(TRIM_DIRECTIVE_COMMENTS_SUFFIX, "-->");
        this.ioSkiperrors = config.asBoolean(IO_SKIPERRORS, "false");
    }

    public List<String> getImportClasses() {
        return this.importClasses;
    }

    public List<String> getImportMethods() {
        return this.importMethods;
    }

    public List<String> getImportFunctions() {
        return this.importFunctions;
    }

    public List<String> getImportTags() {
        return this.importTags;
    }

    public List<String> getImportMacros() {
        return this.importMacros;
    }

    public List<String> getImportDefines() {
        return this.importDefines;
    }

    public List<String> getAutoscanPackages() {
        return this.autoscanPackages;
    }

    public boolean isAutoscanSkiperrors() {
        return this.autoscanSkiperrors;
    }

    public List<ResourceLoader> getTemplateLoaders() {
        return this.templateLoaders;
    }

    public String getTemplateSuffix() {
        return this.templateSuffix;
    }

    public JetSecurityManager getTemplateSecurityManager() {
        return this.templateSecurityManager;
    }

    public Charset getInputEncoding() {
        return this.inputEncoding;
    }

    public Charset getOutputEncoding() {
        return this.outputEncoding;
    }

    public boolean isSyntaxStrict() {
        return this.syntaxStrict;
    }

    public boolean isSyntaxSafecall() {
        return this.syntaxSafecall;
    }

    public boolean isTrimLeadingWhitespaces() {
        return this.trimLeadingWhitespaces;
    }

    public boolean isTrimDirectiveWhitespaces() {
        return this.trimDirectiveWhitespaces;
    }

    public boolean isTrimDirectiveComments() {
        return this.trimDirectiveComments;
    }

    public String getTrimDirectiveCommentsPrefix() {
        return this.trimDirectiveCommentsPrefix;
    }

    public String getTrimDirectiveCommentsSuffix() {
        return this.trimDirectiveCommentsSuffix;
    }

    public boolean isIoSkiperrors() {
        return this.ioSkiperrors;
    }
}

