/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template;

import java.util.HashMap;
import java.util.Map;
import jetbrick.template.Errors;

public final class JetGlobalContext {
    private final Map<String, Class<?>> symbols = new HashMap();
    private final Map<String, Object> context = new HashMap<String, Object>();

    public void define(Class<?> type, String name) {
        Class<?> old = this.symbols.put(name, type);
        if (old != null) {
            throw new IllegalStateException(Errors.format("cannot redefine variable: %s", name));
        }
    }

    public void set(Class<?> type, String name, Object value) {
        this.define(type, name);
        this.set(name, value);
    }

    public void set(String name, Object value) {
        Class<?> type = this.symbols.get(name);
        if (type != null && value != null && !type.isInstance(value)) {
            throw new IllegalStateException(Errors.format("inconsistent class for variable: `%s` is not %s", name, type.getName()));
        }
        this.context.put(name, value);
    }

    public Class<?> getType(String name) {
        return this.symbols.get(name);
    }

    public Object getValue(String name) {
        return this.context.get(name);
    }
}

