/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public final class DateUtils {
    public static final long SECOND_IN_MILLIS = 1000L;
    public static final long MINITE_IN_MILLIS = 60000L;
    public static final long HOUR_IN_MILLIS = 3600000L;
    public static final long DAY_IN_MILLIS = 86400000L;
    public static final long WEEK_IN_MILLIS = 604800000L;
    public static final String STD_DATE_PATTERN = "yyyy-MM-dd";
    public static final String STD_TIME_PATTERN = "HH:mm:ss";
    public static final String STD_DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String RFC822_DATETIME_PATTERN = "EEE, dd MMM yyyy HH:mm:ss 'GMT'";
    public static final String W3C_DATETIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String[] RFC822_PATTENRS = new String[]{"EEE, dd MMM yy HH:mm:ss z", "EEE, dd MMM yy HH:mm z", "dd MMM yy HH:mm:ss z", "dd MMM yy HH:mm z"};
    private static final String[] W3CDATETIME_PATTERNS = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSSz", "yyyy-MM-dd't'HH:mm:ss.SSSz", "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "yyyy-MM-dd't'HH:mm:ss.SSS'z'", "yyyy-MM-dd'T'HH:mm:ssz", "yyyy-MM-dd't'HH:mm:ssz", "yyyy-MM-dd'T'HH:mm:ss'Z'", "yyyy-MM-dd't'HH:mm:ss'z'", "yyyy-MM-dd'T'HH:mmz", "yyyy-MM'T'HH:mmz", "yyyy'T'HH:mmz", "yyyy-MM-dd't'HH:mmz", "yyyy-MM-dd'T'HH:mm'Z'", "yyyy-MM-dd't'HH:mm'z'", "yyyy-MM-dd", "yyyy-MM", "yyyy"};
    private static final String[] STD_PATTERNS = new String[]{"yyyy-MM-dd HH:mm:ss,SSS", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM-dd", "yyyy/MM/dd HH:mm:ss,SSS", "yyyy/MM/dd HH:mm:ss.SSS", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/MM/dd", "yyyyMMddHHmmss", "yyyyMMdd", "hh:mm:ss,SSS", "hh:mm:ss.SSS", "hh:mm:ss"};

    public static String format(String pattern) {
        return DateUtils.format(new Date(), pattern);
    }

    public static String format(Date date, String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        return df.format(date);
    }

    public static Date parse(String date) {
        Date d = DateUtils.parse(date, STD_PATTERNS);
        if (d == null) {
            d = DateUtils.parseRFC822Date(date);
        }
        if (d == null) {
            d = DateUtils.parseW3CDateTime(date);
        }
        if (d == null) {
            try {
                d = DateFormat.getInstance().parse(date);
            }
            catch (ParseException e) {
                d = null;
            }
        }
        return d;
    }

    public static Date parse(String date, String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        df.setLenient(false);
        try {
            ParsePosition pp = new ParsePosition(0);
            Date d = df.parse(date, pp);
            if (d != null && pp.getIndex() == date.length()) {
                return d;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Date parse(String date, String[] patterns) {
        if (date == null || date.length() == 0) {
            return null;
        }
        date = date.trim();
        for (String pattern : patterns) {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            df.setLenient(false);
            try {
                ParsePosition pp = new ParsePosition(0);
                Date d = df.parse(date, pp);
                if (d == null || pp.getIndex() != date.length()) continue;
                return d;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    public static Date parseRFC822Date(String date) {
        int ipos = date.indexOf(" UT");
        if (ipos > -1) {
            String pre = date.substring(0, ipos);
            String post = date.substring(ipos + 3);
            date = pre + " GMT" + post;
        }
        return DateUtils.parse(date, RFC822_PATTENRS);
    }

    public static Date parseW3CDateTime(String date) {
        int tIndex = date.indexOf("T");
        if (tIndex > -1) {
            int tzdIndex;
            if (date.endsWith("Z")) {
                date = date.substring(0, date.length() - 1) + "+00:00";
            }
            if ((tzdIndex = date.indexOf("+", tIndex)) == -1) {
                tzdIndex = date.indexOf("-", tIndex);
            }
            if (tzdIndex > -1) {
                String pre = date.substring(0, tzdIndex);
                int secFraction = pre.indexOf(",");
                if (secFraction > -1) {
                    pre = pre.substring(0, secFraction);
                }
                String post = date.substring(tzdIndex);
                date = pre + "GMT" + post;
            }
        } else {
            date = date + "T00:00GMT";
        }
        return DateUtils.parse(date, W3CDATETIME_PATTERNS);
    }

    public static String formatRFC822(Date date) {
        SimpleDateFormat df = new SimpleDateFormat(RFC822_DATETIME_PATTERN);
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df.format(date);
    }

    public static String formatW3CDateTime(Date date) {
        SimpleDateFormat df = new SimpleDateFormat(W3C_DATETIME_PATTERN);
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df.format(date);
    }
}

