/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import jetbrick.util.PathUtils;
import jetbrick.util.StringUtils;

public final class ClasspathUtils {
    public static final String EXT_CLASS_LOADER_NAME = "sun.misc.Launcher$ExtClassLoader";
    public static final String APP_CLASS_LOADER_NAME = "sun.misc.Launcher$AppClassLoader";

    public static Collection<URL> getClasspathURLs(ClassLoader classLoader) {
        String className;
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>(32);
        for (ClassLoader loader = classLoader; loader != null && !EXT_CLASS_LOADER_NAME.equals(className = loader.getClass().getName()); loader = loader.getParent()) {
            if (loader instanceof URLClassLoader) {
                for (URL uRL : ((URLClassLoader)loader).getURLs()) {
                    urls.add(uRL);
                }
                continue;
            }
            if (className.startsWith("weblogic.utils.classloaders.")) {
                try {
                    String[] paths;
                    Method method = loader.getClass().getMethod("getClassPath", new Class[0]);
                    Object result = method.invoke((Object)loader, new Object[0]);
                    if (result == null) continue;
                    String[] stringArray = paths = StringUtils.split(result.toString(), File.pathSeparatorChar);
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String path = stringArray[i];
                        urls.add(PathUtils.fileAsUrl(path));
                    }
                    continue;
                }
                catch (NoSuchMethodException e) {
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (!className.startsWith("org.jboss.modules.ModuleClassLoader")) continue;
            try {
                Set<URL> urlSet = JBossModuleUtils.getClasspathURLs(loader, false);
                urls.addAll(urlSet);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        String jsp_classpath = System.getProperty("org.apache.catalina.jsp_classpath");
        String classpath = System.getProperty("java.class.path");
        if ((classpath = StringUtils.trimToEmpty(classpath) + File.pathSeparatorChar + StringUtils.trimToEmpty(jsp_classpath)).length() > 1) {
            String[] paths;
            for (String path : paths = StringUtils.split(classpath, File.pathSeparatorChar)) {
                if ((path = path.trim()).length() <= 0) continue;
                URL url = PathUtils.fileAsUrl(path);
                urls.add(url);
            }
        }
        try {
            Enumeration<URL> paths = classLoader.getResources("META-INF/MANIFEST.MF");
            while (paths.hasMoreElements()) {
                URL url = paths.nextElement();
                File file = PathUtils.urlAsFile(url);
                urls.add(file.toURI().toURL());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Iterator it = urls.iterator();
        while (it.hasNext()) {
            String path = ((URL)it.next()).getPath();
            if (!path.contains("/jre/lib/")) continue;
            it.remove();
        }
        return urls;
    }

    public static Collection<URL> getClasspathURLs(ClassLoader classLoader, String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException("PackageName must be not null.");
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        String dirname = packageName.replace('.', '/');
        try {
            Enumeration<URL> dirs = classLoader.getResources(dirname);
            while (dirs.hasMoreElements()) {
                urls.add(dirs.nextElement());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return urls;
    }

    static class JBossModuleUtils {
        JBossModuleUtils() {
        }

        public static Set<URL> getClasspathURLs(Object rootModuleClassLoader, boolean allModules) throws Exception {
            LinkedHashSet<URL> urls = new LinkedHashSet<URL>(256);
            Method method = rootModuleClassLoader.getClass().getDeclaredMethod("findResources", String.class, Boolean.TYPE);
            method.setAccessible(true);
            Enumeration url = (Enumeration)method.invoke(rootModuleClassLoader, "", true);
            while (url.hasMoreElements()) {
                urls.add((URL)url.nextElement());
            }
            if (allModules) {
                Object moudle = JBossModuleUtils.getFieldValue(rootModuleClassLoader, "module");
                Object moduleLoader = JBossModuleUtils.getFieldValue(moudle, "moduleLoader");
                Object mainModuleLoader = JBossModuleUtils.getFieldValue(moduleLoader, "mainModuleLoader");
                Map moduleMap = (Map)JBossModuleUtils.getFieldValue(mainModuleLoader, "moduleMap");
                for (Object futureModule : moduleMap.values()) {
                    Object m = JBossModuleUtils.getFieldValue(futureModule, "module");
                    Object mcl = JBossModuleUtils.getFieldValue(m, "moduleClassLoader");
                    urls.addAll(JBossModuleUtils.getModuleClassLoaderURLs(mcl));
                }
            }
            return urls;
        }

        private static Set<URL> getModuleClassLoaderURLs(Object moduleClassLoader) throws Exception {
            LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
            Method method = moduleClassLoader.getClass().getDeclaredMethod("getResourceLoaders", new Class[0]);
            method.setAccessible(true);
            Object[] resourceLoaders = (Object[])method.invoke(moduleClassLoader, new Object[0]);
            if (resourceLoaders != null) {
                for (Object resourceLoader : resourceLoaders) {
                    URL url;
                    if (resourceLoader == null) continue;
                    String name = resourceLoader.getClass().getName();
                    if ("org.jboss.modules.NativeLibraryResourceLoader".equals(name) || "org.jboss.modules.FileResourceLoader".equals(name)) {
                        File file = (File)JBossModuleUtils.getFieldValue(resourceLoader, "root");
                        urls.add(PathUtils.fileAsUrl(file));
                        continue;
                    }
                    if ("org.jboss.modules.JarFileResourceLoader".equals(name)) {
                        url = (URL)JBossModuleUtils.getFieldValue(resourceLoader, "rootUrl");
                        urls.add(url);
                        continue;
                    }
                    if ("org.jboss.as.server.deployment.module.VFSResourceLoader".equals(name)) {
                        url = (URL)JBossModuleUtils.getFieldValue(resourceLoader, "rootUrl");
                        urls.add(url);
                        continue;
                    }
                    throw new IllegalStateException("Unsupported ResourceLoader: " + name);
                }
            }
            return urls;
        }

        private static Object getFieldValue(Object object, String name) throws Exception {
            for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
                try {
                    Field field = clazz.getDeclaredField(name);
                    field.setAccessible(true);
                    return field.get(object);
                }
                catch (NoSuchFieldException e) {
                    continue;
                }
            }
            throw new NoSuchFieldException(object.getClass().getName() + '#' + name);
        }
    }
}

