/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.typecast.support;

import jetbrick.typecast.Convertor;
import jetbrick.typecast.TypeCastException;

public final class DoubleConvertor
implements Convertor<Double> {
    public static final DoubleConvertor INSTANCE = new DoubleConvertor();

    @Override
    public Double convert(String value) {
        if (value == null) {
            return null;
        }
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw TypeCastException.create(value, Double.class, e);
        }
    }

    @Override
    public Double convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass() == Double.class) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return this.convert(value.toString());
    }
}

