/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.util.annotation;

public class ValueConstants {
    public static final String EMPTY = "";
    public static final String NULL = "\u0000\u0001\u0002";

    public static boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }

    public static boolean isNull(String value) {
        return value == null || NULL.equals(value);
    }

    public static boolean isEmptyOrNull(String value) {
        return value == null || value.length() == 0 || NULL.equals(value);
    }

    public static String defaultValue(String value, String defaultValue) {
        if (value == null || value.length() == 0 || NULL.equals(value)) {
            return defaultValue;
        }
        return value;
    }

    public static String defaultIfEmpty(String value, String defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        return value;
    }

    public static String defaultIfNull(String value, String defaultValue) {
        if (value == null || NULL.equals(value)) {
            return defaultValue;
        }
        return value;
    }

    public static String trimToNull(String value) {
        if (value == null || value.length() == 0 || NULL.equals(value)) {
            return null;
        }
        return value;
    }

    public static String trimToEmpty(String value) {
        if (value == null || value.length() == 0 || NULL.equals(value)) {
            return EMPTY;
        }
        return value;
    }
}

