/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.typecast.support;

import java.util.Calendar;
import jetbrick.typecast.Convertor;
import jetbrick.typecast.support.DateConvertor;

public final class CalendarConvertor
implements Convertor<Calendar> {
    public static final CalendarConvertor INSTANCE = new CalendarConvertor();

    @Override
    public Calendar convert(String value) {
        if (value == null) {
            return null;
        }
        long millis = DateConvertor.toMilliseconds(value, Calendar.class);
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(millis);
        return cal;
    }

    @Override
    public Calendar convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Calendar) {
            return (Calendar)value;
        }
        long millis = DateConvertor.toMilliseconds(value, Calendar.class);
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(millis);
        return cal;
    }
}

