/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.io.file;

import java.io.File;
import java.io.IOException;

public final class FileUtils {
    public static final long ONE_KB = 1024L;
    public static final long ONE_MB = 0x100000L;
    public static final long ONE_GB = 0x40000000L;

    public static long getFileSize(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException(file + " does not exist.");
        }
        if (file.isDirectory()) {
            return FileUtils.getFolderSize(file);
        }
        return file.length();
    }

    public static long getFolderSize(File directory) {
        if (!directory.exists()) {
            throw new IllegalArgumentException(directory + " does not exist.");
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(directory + " is not a directory.");
        }
        File[] files = directory.listFiles();
        if (files == null) {
            return 0L;
        }
        long size = 0L;
        for (File file : files) {
            try {
                if (FileUtils.isSymbolLink(file) || (size += FileUtils.getFileSize(file)) >= 0L) continue;
                break;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return size;
    }

    public static boolean isSymbolLink(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("File must not be null.");
        }
        if (File.separatorChar == '\\') {
            return false;
        }
        File fileInCanonicalDir = null;
        if (file.getParent() == null) {
            fileInCanonicalDir = file;
        } else {
            File canonicalDir = file.getParentFile().getCanonicalFile();
            fileInCanonicalDir = new File(canonicalDir, file.getName());
        }
        return !fileInCanonicalDir.getCanonicalFile().equals(fileInCanonicalDir.getAbsoluteFile());
    }
}

