/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.tasktracker.monitor;

import com.github.ltsopensource.core.factory.NamedThreadFactory;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.support.SystemClock;
import com.github.ltsopensource.ec.EventInfo;
import com.github.ltsopensource.ec.EventSubscriber;
import com.github.ltsopensource.ec.Observer;
import com.github.ltsopensource.tasktracker.domain.TaskTrackerAppContext;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class StopWorkingMonitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(StopWorkingMonitor.class);
    private TaskTrackerAppContext appContext;
    private AtomicBoolean start = new AtomicBoolean(false);
    private final ScheduledExecutorService SCHEDULED_CHECKER = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("LTS-StopWorking-Monitor", true));
    private ScheduledFuture<?> scheduledFuture;
    private String ecSubscriberName = StopWorkingMonitor.class.getSimpleName();
    private EventSubscriber eventSubscriber;
    private Long offlineTimestamp = null;

    public StopWorkingMonitor(TaskTrackerAppContext appContext) {
        this.appContext = appContext;
    }

    public void start() {
        try {
            if (this.start.compareAndSet(false, true)) {
                this.eventSubscriber = new EventSubscriber(this.ecSubscriberName, new Observer(){

                    public void onObserved(EventInfo eventInfo) {
                        StopWorkingMonitor.this.offlineTimestamp = null;
                    }
                });
                this.appContext.getEventCenter().subscribe(this.eventSubscriber, new String[]{"JOB_TRACKER_AVAILABLE"});
                this.scheduledFuture = this.SCHEDULED_CHECKER.scheduleWithFixedDelay(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (StopWorkingMonitor.this.offlineTimestamp == null && StopWorkingMonitor.this.appContext.getRemotingClient().isServerEnable()) {
                                StopWorkingMonitor.this.offlineTimestamp = SystemClock.now();
                            }
                            if (StopWorkingMonitor.this.offlineTimestamp != null && SystemClock.now() - StopWorkingMonitor.this.offlineTimestamp > 10000L) {
                                StopWorkingMonitor.this.appContext.getRunnerPool().stopWorking();
                                StopWorkingMonitor.this.offlineTimestamp = null;
                            }
                        }
                        catch (Throwable t) {
                            LOGGER.error("Check ", t);
                        }
                    }
                }, 3L, 3L, TimeUnit.SECONDS);
                LOGGER.info("start succeed ");
            }
        }
        catch (Throwable t) {
            LOGGER.error("start failed ", t);
        }
    }

    public void stop() {
        try {
            if (this.start.compareAndSet(true, false)) {
                this.scheduledFuture.cancel(true);
                this.SCHEDULED_CHECKER.shutdown();
                this.appContext.getEventCenter().unSubscribe("JOB_TRACKER_AVAILABLE", this.eventSubscriber);
                LOGGER.info("stop succeed ");
            }
        }
        catch (Throwable t) {
            LOGGER.error("stop failed ", t);
        }
    }
}

