/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.tasktracker.logger;

import com.github.ltsopensource.core.AppContext;
import com.github.ltsopensource.core.commons.utils.Callable;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.constant.Level;
import com.github.ltsopensource.core.domain.BizLog;
import com.github.ltsopensource.core.domain.JobMeta;
import com.github.ltsopensource.core.exception.JobTrackerNotFoundException;
import com.github.ltsopensource.core.failstore.FailStorePathBuilder;
import com.github.ltsopensource.core.protocol.JobProtos;
import com.github.ltsopensource.core.protocol.command.AbstractRemotingCommandBody;
import com.github.ltsopensource.core.protocol.command.BizLogSendRequest;
import com.github.ltsopensource.core.protocol.command.CommandBodyWrapper;
import com.github.ltsopensource.core.remoting.RemotingClientDelegate;
import com.github.ltsopensource.core.support.NodeShutdownHook;
import com.github.ltsopensource.core.support.RetryScheduler;
import com.github.ltsopensource.core.support.SystemClock;
import com.github.ltsopensource.remoting.AsyncCallback;
import com.github.ltsopensource.remoting.RemotingCommandBody;
import com.github.ltsopensource.remoting.ResponseFuture;
import com.github.ltsopensource.remoting.protocol.RemotingCommand;
import com.github.ltsopensource.tasktracker.domain.TaskTrackerAppContext;
import com.github.ltsopensource.tasktracker.logger.BizLogger;
import com.github.ltsopensource.tasktracker.logger.BizLoggerAdapter;
import java.util.Collections;
import java.util.List;

public class BizLoggerImpl
extends BizLoggerAdapter
implements BizLogger {
    private Level level;
    private RemotingClientDelegate remotingClient;
    private TaskTrackerAppContext appContext;
    private RetryScheduler<BizLog> retryScheduler;

    public BizLoggerImpl(Level level, final RemotingClientDelegate remotingClient, TaskTrackerAppContext appContext) {
        this.level = level;
        if (this.level == null) {
            this.level = Level.INFO;
        }
        this.appContext = appContext;
        this.remotingClient = remotingClient;
        this.retryScheduler = new RetryScheduler<BizLog>(BizLogger.class.getSimpleName(), (AppContext)appContext, FailStorePathBuilder.getBizLoggerPath((AppContext)appContext)){

            protected boolean isRemotingEnable() {
                return remotingClient.isServerEnable();
            }

            protected boolean retry(List<BizLog> list) {
                return BizLoggerImpl.this.sendBizLog(list);
            }
        };
        this.retryScheduler.start();
        NodeShutdownHook.registerHook((AppContext)appContext, (String)this.getClass().getName(), (Callable)new Callable(){

            public void call() throws Exception {
                BizLoggerImpl.this.retryScheduler.stop();
            }
        });
    }

    @Override
    public void debug(String msg) {
        if (this.level.ordinal() <= Level.DEBUG.ordinal()) {
            this.sendMsg(msg);
        }
    }

    @Override
    public void info(String msg) {
        if (this.level.ordinal() <= Level.INFO.ordinal()) {
            this.sendMsg(msg);
        }
    }

    @Override
    public void error(String msg) {
        if (this.level.ordinal() <= Level.ERROR.ordinal()) {
            this.sendMsg(msg);
        }
    }

    private void sendMsg(String msg) {
        BizLogSendRequest requestBody = (BizLogSendRequest)CommandBodyWrapper.wrapper((AppContext)this.appContext, (AbstractRemotingCommandBody)new BizLogSendRequest());
        final BizLog bizLog = new BizLog();
        bizLog.setTaskTrackerIdentity(requestBody.getIdentity());
        bizLog.setTaskTrackerNodeGroup(requestBody.getNodeGroup());
        bizLog.setLogTime(Long.valueOf(SystemClock.now()));
        JobMeta jobMeta = this.getJobMeta();
        bizLog.setJobId(jobMeta.getJobId());
        bizLog.setTaskId(jobMeta.getJob().getTaskId());
        bizLog.setRealTaskId(jobMeta.getRealTaskId());
        bizLog.setJobType(jobMeta.getJobType());
        bizLog.setMsg(msg);
        bizLog.setLevel(this.level);
        requestBody.setBizLogs(Collections.singletonList(bizLog));
        if (!this.remotingClient.isServerEnable()) {
            this.retryScheduler.inSchedule(StringUtils.generateUUID(), (Object)bizLog);
            return;
        }
        RemotingCommand request = RemotingCommand.createRequestCommand((int)JobProtos.RequestCode.BIZ_LOG_SEND.code(), (RemotingCommandBody)requestBody);
        try {
            this.remotingClient.invokeAsync(request, new AsyncCallback(){

                public void operationComplete(ResponseFuture responseFuture) {
                    RemotingCommand response = responseFuture.getResponseCommand();
                    if (response == null || response.getCode() != JobProtos.ResponseCode.BIZ_LOG_SEND_SUCCESS.code()) {
                        BizLoggerImpl.this.retryScheduler.inSchedule(StringUtils.generateUUID(), (Object)bizLog);
                    }
                }
            });
        }
        catch (JobTrackerNotFoundException e) {
            this.retryScheduler.inSchedule(StringUtils.generateUUID(), (Object)bizLog);
        }
    }

    private boolean sendBizLog(List<BizLog> bizLogs) {
        if (CollectionUtils.isEmpty(bizLogs)) {
            return true;
        }
        BizLogSendRequest requestBody = (BizLogSendRequest)CommandBodyWrapper.wrapper((AppContext)this.appContext, (AbstractRemotingCommandBody)new BizLogSendRequest());
        requestBody.setBizLogs(bizLogs);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)JobProtos.RequestCode.BIZ_LOG_SEND.code(), (RemotingCommandBody)requestBody);
        try {
            RemotingCommand response = this.remotingClient.invokeSync(request);
            if (response != null && response.getCode() == JobProtos.ResponseCode.BIZ_LOG_SEND_SUCCESS.code()) {
                return true;
            }
        }
        catch (JobTrackerNotFoundException ignored) {
            // empty catch block
        }
        return false;
    }
}

