/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.tasktracker;

import com.github.ltsopensource.cmd.HttpCmdProc;
import com.github.ltsopensource.core.cluster.AbstractClientNode;
import com.github.ltsopensource.core.constant.Level;
import com.github.ltsopensource.core.monitor.MStatReporter;
import com.github.ltsopensource.remoting.RemotingProcessor;
import com.github.ltsopensource.tasktracker.cmd.JobTerminateCmd;
import com.github.ltsopensource.tasktracker.domain.TaskTrackerAppContext;
import com.github.ltsopensource.tasktracker.domain.TaskTrackerNode;
import com.github.ltsopensource.tasktracker.monitor.StopWorkingMonitor;
import com.github.ltsopensource.tasktracker.monitor.TaskTrackerMStatReporter;
import com.github.ltsopensource.tasktracker.processor.RemotingDispatcher;
import com.github.ltsopensource.tasktracker.runner.JobRunner;
import com.github.ltsopensource.tasktracker.runner.RunnerFactory;
import com.github.ltsopensource.tasktracker.runner.RunnerPool;
import com.github.ltsopensource.tasktracker.support.JobPullMachine;

public class TaskTracker
extends AbstractClientNode<TaskTrackerNode, TaskTrackerAppContext> {
    public TaskTracker() {
        ((TaskTrackerAppContext)this.appContext).setMStatReporter((MStatReporter)new TaskTrackerMStatReporter(this.appContext));
    }

    protected void beforeStart() {
        ((TaskTrackerAppContext)this.appContext).setRemotingClient(this.remotingClient);
        ((TaskTrackerAppContext)this.appContext).setRunnerPool(new RunnerPool((TaskTrackerAppContext)this.appContext));
        ((TaskTrackerAppContext)this.appContext).getMStatReporter().start();
        ((TaskTrackerAppContext)this.appContext).setJobPullMachine(new JobPullMachine((TaskTrackerAppContext)this.appContext));
        ((TaskTrackerAppContext)this.appContext).setStopWorkingMonitor(new StopWorkingMonitor((TaskTrackerAppContext)this.appContext));
        ((TaskTrackerAppContext)this.appContext).getHttpCmdServer().registerCommands(new HttpCmdProc[]{new JobTerminateCmd((TaskTrackerAppContext)this.appContext)});
    }

    protected void afterStart() {
        if (this.config.getParameter("tasktracker.stop.working.enable", false)) {
            ((TaskTrackerAppContext)this.appContext).getStopWorkingMonitor().start();
        }
    }

    protected void afterStop() {
        ((TaskTrackerAppContext)this.appContext).getMStatReporter().stop();
        ((TaskTrackerAppContext)this.appContext).getStopWorkingMonitor().stop();
        ((TaskTrackerAppContext)this.appContext).getRunnerPool().shutDown();
    }

    protected void beforeStop() {
    }

    protected RemotingProcessor getDefaultProcessor() {
        return new RemotingDispatcher((TaskTrackerAppContext)this.appContext);
    }

    public <JRC extends JobRunner> void setJobRunnerClass(Class<JRC> clazz) {
        ((TaskTrackerAppContext)this.appContext).setJobRunnerClass(clazz);
    }

    public void setWorkThreads(int workThreads) {
        this.config.setWorkThreads(workThreads);
    }

    public void setBizLoggerLevel(Level level) {
        if (level != null) {
            ((TaskTrackerAppContext)this.appContext).setBizLogLevel(level);
        }
    }

    public void setRunnerFactory(RunnerFactory factory) {
        ((TaskTrackerAppContext)this.appContext).setRunnerFactory(factory);
    }
}

