/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.spring.quartz;

import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.spring.quartz.QuartzLTSConfig;
import com.github.ltsopensource.spring.quartz.QuartzLTSProxyAgent;
import com.github.ltsopensource.spring.quartz.QuartzProxyContext;
import com.github.ltsopensource.spring.quartz.QuartzSchedulerBeanRegistrar;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class QuartzLTSProxyBean
implements BeanFactoryPostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuartzLTSProxyBean.class);
    private boolean ltsEnable = true;
    private String clusterName;
    private String nodeGroup;
    private String registryAddress;
    private String dataPath;
    private boolean replaceOnExist = true;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.ltsEnable) {
            LOGGER.info("========LTS====== Proxy Quartz Scheduler");
            QuartzLTSConfig quartzLTSConfig = new QuartzLTSConfig();
            quartzLTSConfig.setClusterName(this.clusterName);
            quartzLTSConfig.setNodeGroup(this.nodeGroup);
            quartzLTSConfig.setRegistryAddress(this.registryAddress);
            quartzLTSConfig.setDataPath(this.dataPath);
            quartzLTSConfig.setReplaceOnExist(this.replaceOnExist);
            QuartzLTSProxyAgent agent = new QuartzLTSProxyAgent(quartzLTSConfig);
            QuartzProxyContext context = new QuartzProxyContext(quartzLTSConfig, agent);
            QuartzSchedulerBeanRegistrar registrar = new QuartzSchedulerBeanRegistrar(context);
            beanFactory.addPropertyEditorRegistrar((PropertyEditorRegistrar)registrar);
        }
    }

    public void setLtsEnable(boolean ltsEnable) {
        this.ltsEnable = ltsEnable;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setNodeGroup(String nodeGroup) {
        this.nodeGroup = nodeGroup;
    }

    public void setRegistryAddress(String registryAddress) {
        this.registryAddress = registryAddress;
    }

    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    public void setReplaceOnExist(boolean replaceOnExist) {
        this.replaceOnExist = replaceOnExist;
    }
}

