/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.spring.boot;

import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.monitor.MonitorAgent;
import com.github.ltsopensource.spring.boot.annotation.EnableMonitor;
import com.github.ltsopensource.spring.boot.properties.MonitorProperties;
import java.util.Map;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(annotation={EnableMonitor.class})
@EnableConfigurationProperties(value={MonitorProperties.class})
public class MonitorAutoConfiguration
implements InitializingBean,
DisposableBean {
    @Autowired(required=false)
    private MonitorProperties properties;
    private MonitorAgent agent;

    public void afterPropertiesSet() throws Exception {
        this.agent = new MonitorAgent();
        this.agent.setRegistryAddress(this.properties.getRegistryAddress());
        if (StringUtils.isNotEmpty((String[])new String[]{this.properties.getClusterName()})) {
            this.agent.setClusterName(this.properties.getClusterName());
        }
        if (StringUtils.isNotEmpty((String[])new String[]{this.properties.getIdentity()})) {
            this.agent.setIdentity(this.properties.getIdentity());
        }
        if (StringUtils.isNotEmpty((String[])new String[]{this.properties.getBindIp()})) {
            this.agent.setBindIp(this.properties.getBindIp());
        }
        if (CollectionUtils.isNotEmpty(this.properties.getConfigs())) {
            for (Map.Entry<String, String> entry : this.properties.getConfigs().entrySet()) {
                this.agent.addConfig(entry.getKey(), entry.getValue());
            }
        }
        this.agent.start();
    }

    public void destroy() throws Exception {
        if (this.agent != null) {
            this.agent.stop();
        }
    }
}

