/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.spring.boot;

import com.github.ltsopensource.core.cluster.AbstractJobNode;
import com.github.ltsopensource.core.cluster.NodeType;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.jobtracker.JobTracker;
import com.github.ltsopensource.spring.boot.AbstractAutoConfiguration;
import com.github.ltsopensource.spring.boot.annotation.EnableJobTracker;
import com.github.ltsopensource.spring.boot.properties.JobTrackerProperties;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(annotation={EnableJobTracker.class})
@EnableConfigurationProperties(value={JobTrackerProperties.class})
public class JobTrackerAutoConfiguration
extends AbstractAutoConfiguration {
    @Autowired(required=false)
    private JobTrackerProperties properties;
    private JobTracker jobTracker;

    @Override
    protected void initJobNode() {
        this.jobTracker = new JobTracker();
        this.jobTracker.setRegistryAddress(this.properties.getRegistryAddress());
        if (StringUtils.isNotEmpty((String[])new String[]{this.properties.getClusterName()})) {
            this.jobTracker.setClusterName(this.properties.getClusterName());
        }
        if (this.properties.getListenPort() != null) {
            this.jobTracker.setListenPort(this.properties.getListenPort().intValue());
        }
        if (StringUtils.isNotEmpty((String[])new String[]{this.properties.getIdentity()})) {
            this.jobTracker.setIdentity(this.properties.getIdentity());
        }
        if (StringUtils.isNotEmpty((String[])new String[]{this.properties.getBindIp()})) {
            this.jobTracker.setBindIp(this.properties.getBindIp());
        }
        if (CollectionUtils.isNotEmpty(this.properties.getConfigs())) {
            for (Map.Entry<String, String> entry : this.properties.getConfigs().entrySet()) {
                this.jobTracker.addConfig(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    protected NodeType nodeType() {
        return NodeType.JOB_TRACKER;
    }

    @Override
    protected AbstractJobNode getJobNode() {
        return this.jobTracker;
    }
}

