/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.spring.boot;

import com.github.ltsopensource.core.cluster.AbstractJobNode;
import com.github.ltsopensource.core.cluster.NodeType;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.jobclient.JobClient;
import com.github.ltsopensource.jobclient.RetryJobClient;
import com.github.ltsopensource.jobclient.support.JobCompletedHandler;
import com.github.ltsopensource.spring.boot.AbstractAutoConfiguration;
import com.github.ltsopensource.spring.boot.annotation.EnableJobClient;
import com.github.ltsopensource.spring.boot.annotation.JobCompletedHandler4JobClient;
import com.github.ltsopensource.spring.boot.properties.JobClientProperties;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(annotation={EnableJobClient.class})
@EnableConfigurationProperties(value={JobClientProperties.class})
public class JobClientAutoConfiguration
extends AbstractAutoConfiguration {
    @Autowired(required=false)
    private JobClientProperties properties;
    private JobClient jobClient;

    @Bean
    public JobClient jobClient() {
        return this.jobClient;
    }

    @Override
    protected void initJobNode() {
        Map handlers;
        this.jobClient = this.properties.isUseRetryClient() ? new RetryJobClient() : new JobClient();
        this.jobClient.setRegistryAddress(this.properties.getRegistryAddress());
        if (StringUtils.isNotEmpty((String[])new String[]{this.properties.getClusterName()})) {
            this.jobClient.setClusterName(this.properties.getClusterName());
        }
        if (StringUtils.isNotEmpty((String[])new String[]{this.properties.getIdentity()})) {
            this.jobClient.setIdentity(this.properties.getIdentity());
        }
        if (StringUtils.isNotEmpty((String[])new String[]{this.properties.getNodeGroup()})) {
            this.jobClient.setNodeGroup(this.properties.getNodeGroup());
        }
        if (StringUtils.isNotEmpty((String[])new String[]{this.properties.getDataPath()})) {
            this.jobClient.setDataPath(this.properties.getDataPath());
        }
        if (StringUtils.isNotEmpty((String[])new String[]{this.properties.getBindIp()})) {
            this.jobClient.setBindIp(this.properties.getBindIp());
        }
        if (CollectionUtils.isNotEmpty(this.properties.getConfigs())) {
            for (Map.Entry<String, String> entry : this.properties.getConfigs().entrySet()) {
                this.jobClient.addConfig(entry.getKey(), entry.getValue());
            }
        }
        if (CollectionUtils.isNotEmpty((Map)(handlers = this.applicationContext.getBeansWithAnnotation(JobCompletedHandler4JobClient.class)))) {
            if (handlers.size() > 1) {
                throw new IllegalArgumentException("annotation @" + JobCompletedHandler4JobClient.class.getSimpleName() + " only should have one");
            }
            for (Map.Entry entry : handlers.entrySet()) {
                Object handler = entry.getValue();
                if (handler instanceof JobCompletedHandler) {
                    this.jobClient.setJobCompletedHandler((JobCompletedHandler)entry.getValue());
                    continue;
                }
                throw new IllegalArgumentException((String)entry.getKey() + "  is not instance of " + JobCompletedHandler.class.getName());
            }
        }
    }

    @Override
    protected NodeType nodeType() {
        return NodeType.JOB_CLIENT;
    }

    @Override
    protected AbstractJobNode getJobNode() {
        return this.jobClient;
    }
}

