/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.spring;

import com.github.ltsopensource.core.commons.utils.Assert;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.constant.Level;
import com.github.ltsopensource.core.listener.MasterChangeListener;
import com.github.ltsopensource.tasktracker.TaskTracker;
import com.github.ltsopensource.tasktracker.runner.JobRunner;
import com.github.ltsopensource.tasktracker.runner.RunnerFactory;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public abstract class TaskTrackerXmlFactoryBean
implements FactoryBean<TaskTracker>,
InitializingBean,
DisposableBean {
    private TaskTracker taskTracker;
    private boolean started;
    private String clusterName;
    private String nodeGroup;
    private String registryAddress;
    private String dataPath;
    private int workThreads;
    private Level bizLoggerLevel;
    private MasterChangeListener[] masterChangeListeners;
    private Properties configs = new Properties();

    public TaskTracker getObject() throws Exception {
        return this.taskTracker;
    }

    public Class<?> getObjectType() {
        return TaskTracker.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void checkProperties() {
        Assert.hasText((String)this.clusterName, (String)"clusterName must have value.");
        Assert.hasText((String)this.nodeGroup, (String)"nodeGroup must have value.");
        Assert.hasText((String)this.registryAddress, (String)"registryAddress must have value.");
        Assert.isTrue((this.workThreads > 0 ? 1 : 0) != 0, (String)"workThreads must > 0.");
    }

    public void afterPropertiesSet() throws Exception {
        this.checkProperties();
        this.taskTracker = new TaskTracker();
        this.taskTracker.setClusterName(this.clusterName);
        this.taskTracker.setDataPath(this.dataPath);
        this.taskTracker.setWorkThreads(this.workThreads);
        this.taskTracker.setNodeGroup(this.nodeGroup);
        this.taskTracker.setRegistryAddress(this.registryAddress);
        if (this.bizLoggerLevel != null) {
            this.taskTracker.setBizLoggerLevel(this.bizLoggerLevel);
        }
        for (Map.Entry<Object, Object> entry : this.configs.entrySet()) {
            this.taskTracker.addConfig(entry.getKey().toString(), entry.getValue().toString());
        }
        this.taskTracker.setRunnerFactory(new RunnerFactory(){

            public JobRunner newRunner() {
                return TaskTrackerXmlFactoryBean.this.createJobRunner();
            }
        });
        if (this.masterChangeListeners != null) {
            for (MasterChangeListener masterChangeListener : this.masterChangeListeners) {
                this.taskTracker.addMasterChangeListener(masterChangeListener);
            }
        }
    }

    public void start() {
        if (!this.started) {
            this.taskTracker.start();
            this.started = true;
        }
    }

    protected abstract JobRunner createJobRunner();

    public void destroy() throws Exception {
        this.taskTracker.stop();
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setNodeGroup(String nodeGroup) {
        this.nodeGroup = nodeGroup;
    }

    public void setRegistryAddress(String registryAddress) {
        this.registryAddress = registryAddress;
    }

    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    public void setWorkThreads(int workThreads) {
        this.workThreads = workThreads;
    }

    public void setMasterChangeListeners(MasterChangeListener[] masterChangeListeners) {
        this.masterChangeListeners = masterChangeListeners;
    }

    public void setBizLoggerLevel(String bizLoggerLevel) {
        if (StringUtils.isNotEmpty((String[])new String[]{bizLoggerLevel})) {
            this.bizLoggerLevel = Level.valueOf((String)bizLoggerLevel);
        }
    }

    public void setConfigs(Properties configs) {
        this.configs = configs;
    }
}

