/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.spring;

import com.github.ltsopensource.core.commons.utils.Assert;
import com.github.ltsopensource.core.listener.MasterChangeListener;
import com.github.ltsopensource.jobtracker.JobTracker;
import com.github.ltsopensource.jobtracker.support.OldDataHandler;
import com.github.ltsopensource.jobtracker.support.policy.OldDataDeletePolicy;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class JobTrackerFactoryBean
implements FactoryBean<JobTracker>,
InitializingBean,
DisposableBean {
    private JobTracker jobTracker;
    private boolean started;
    private String clusterName;
    private String registryAddress;
    private MasterChangeListener[] masterChangeListeners;
    private Properties configs = new Properties();
    private Integer listenPort;
    private OldDataHandler oldDataHandler;

    public JobTracker getObject() throws Exception {
        return this.jobTracker;
    }

    public Class<?> getObjectType() {
        return JobTracker.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void checkProperties() {
        Assert.hasText((String)this.clusterName, (String)"clusterName must have value.");
        Assert.hasText((String)this.registryAddress, (String)"registryAddress must have value.");
    }

    public void afterPropertiesSet() throws Exception {
        this.checkProperties();
        this.jobTracker = new JobTracker();
        this.jobTracker.setClusterName(this.clusterName);
        this.jobTracker.setRegistryAddress(this.registryAddress);
        if (this.listenPort != null) {
            this.jobTracker.setListenPort(this.listenPort.intValue());
        }
        if (this.oldDataHandler == null) {
            this.jobTracker.setOldDataHandler((OldDataHandler)new OldDataDeletePolicy());
        } else {
            this.jobTracker.setOldDataHandler(this.oldDataHandler);
        }
        for (Map.Entry<Object, Object> entry : this.configs.entrySet()) {
            this.jobTracker.addConfig(entry.getKey().toString(), entry.getValue().toString());
        }
        if (this.masterChangeListeners != null) {
            for (MasterChangeListener masterChangeListener : this.masterChangeListeners) {
                this.jobTracker.addMasterChangeListener(masterChangeListener);
            }
        }
    }

    public void start() {
        if (!this.started) {
            this.jobTracker.start();
            this.started = true;
        }
    }

    public void destroy() throws Exception {
        this.jobTracker.stop();
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setRegistryAddress(String registryAddress) {
        this.registryAddress = registryAddress;
    }

    public void setMasterChangeListeners(MasterChangeListener[] masterChangeListeners) {
        this.masterChangeListeners = masterChangeListeners;
    }

    public void setConfigs(Properties configs) {
        this.configs = configs;
    }

    public void setOldDataHandler(OldDataHandler oldDataHandler) {
        this.oldDataHandler = oldDataHandler;
    }

    public void setListenPort(Integer listenPort) {
        this.listenPort = listenPort;
    }
}

