/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.spring;

import com.github.ltsopensource.core.commons.utils.Assert;
import com.github.ltsopensource.core.listener.MasterChangeListener;
import com.github.ltsopensource.jobclient.JobClient;
import com.github.ltsopensource.jobclient.RetryJobClient;
import com.github.ltsopensource.jobclient.support.JobCompletedHandler;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class JobClientFactoryBean
implements FactoryBean<JobClient>,
InitializingBean,
DisposableBean {
    private JobClient jobClient;
    private boolean started;
    private String clusterName;
    private String nodeGroup;
    private String registryAddress;
    private String dataPath;
    private MasterChangeListener[] masterChangeListeners;
    private Properties configs = new Properties();
    private String type;
    private JobCompletedHandler jobCompletedHandler;

    public JobClient getObject() throws Exception {
        return this.jobClient;
    }

    public Class<?> getObjectType() {
        return JobClient.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void checkProperties() {
        Assert.hasText((String)this.clusterName, (String)"clusterName must have value.");
        Assert.hasText((String)this.nodeGroup, (String)"nodeGroup must have value.");
        Assert.hasText((String)this.registryAddress, (String)"registryAddress must have value.");
    }

    public void afterPropertiesSet() throws Exception {
        this.checkProperties();
        this.jobClient = "NORMAL".equals(this.type) ? new JobClient() : new RetryJobClient();
        this.jobClient.setClusterName(this.clusterName);
        this.jobClient.setDataPath(this.dataPath);
        this.jobClient.setNodeGroup(this.nodeGroup);
        this.jobClient.setRegistryAddress(this.registryAddress);
        if (this.jobCompletedHandler != null) {
            this.jobClient.setJobCompletedHandler(this.jobCompletedHandler);
        }
        for (Map.Entry<Object, Object> entry : this.configs.entrySet()) {
            this.jobClient.addConfig(entry.getKey().toString(), entry.getValue().toString());
        }
        if (this.masterChangeListeners != null) {
            for (MasterChangeListener masterChangeListener : this.masterChangeListeners) {
                this.jobClient.addMasterChangeListener(masterChangeListener);
            }
        }
    }

    public void start() {
        if (!this.started) {
            this.jobClient.start();
            this.started = true;
        }
    }

    public void destroy() throws Exception {
        this.jobClient.stop();
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setNodeGroup(String nodeGroup) {
        this.nodeGroup = nodeGroup;
    }

    public void setRegistryAddress(String registryAddress) {
        this.registryAddress = registryAddress;
    }

    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    public void setMasterChangeListeners(MasterChangeListener[] masterChangeListeners) {
        this.masterChangeListeners = masterChangeListeners;
    }

    public void setConfigs(Properties configs) {
        this.configs = configs;
    }

    public void setJobCompletedHandler(JobCompletedHandler jobCompletedHandler) {
        this.jobCompletedHandler = jobCompletedHandler;
    }

    public void setType(String type) {
        this.type = type;
    }
}

