/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.monitor.cmd;

import com.github.ltsopensource.cmd.HttpCmdProc;
import com.github.ltsopensource.cmd.HttpCmdRequest;
import com.github.ltsopensource.cmd.HttpCmdResponse;
import com.github.ltsopensource.core.cluster.NodeType;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.domain.monitor.JobClientMData;
import com.github.ltsopensource.core.domain.monitor.JobTrackerMData;
import com.github.ltsopensource.core.domain.monitor.MData;
import com.github.ltsopensource.core.domain.monitor.MNode;
import com.github.ltsopensource.core.domain.monitor.TaskTrackerMData;
import com.github.ltsopensource.core.json.JSON;
import com.github.ltsopensource.core.json.TypeReference;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.monitor.MonitorAppContext;
import java.lang.reflect.Type;
import java.util.List;

public class MDataAddHttpCmd
implements HttpCmdProc {
    private static final Logger LOGGER = LoggerFactory.getLogger(MDataAddHttpCmd.class);
    private MonitorAppContext appContext;

    public MDataAddHttpCmd(MonitorAppContext appContext) {
        this.appContext = appContext;
    }

    public String nodeIdentity() {
        return this.appContext.getConfig().getIdentity();
    }

    public String getCommand() {
        return "monitor_data_add_cmd";
    }

    public HttpCmdResponse execute(HttpCmdRequest request) throws Exception {
        String mNodeJson = request.getParam("mNode");
        if (StringUtils.isEmpty((String)mNodeJson)) {
            return HttpCmdResponse.newResponse((boolean)false, (String)"mData is empty");
        }
        MNode mNode = (MNode)JSON.parse((String)mNodeJson, (Type)new TypeReference<MNode>(){}.getType());
        HttpCmdResponse response = this.paramCheck(mNode);
        if (response != null) {
            return response;
        }
        String mDataJson = request.getParam("mData");
        if (StringUtils.isEmpty((String)mDataJson)) {
            return HttpCmdResponse.newResponse((boolean)false, (String)"mData is empty");
        }
        try {
            assert (mNode != null);
            List<MData> mDatas = this.getMDataList(mNode.getNodeType(), mDataJson);
            this.appContext.getMDataSrv().addMDatas(mNode, mDatas);
        }
        catch (Exception e) {
            LOGGER.error("Add Monitor Data error: " + JSON.toJSONString((Object)request), (Throwable)e);
            return HttpCmdResponse.newResponse((boolean)false, (String)("Add Monitor Data error: " + e.getMessage()));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Add Monitor Data success, mNode=" + mNodeJson + ", mData=" + mDataJson);
        }
        return HttpCmdResponse.newResponse((boolean)true, (String)"Add Monitor Data success");
    }

    private List<MData> getMDataList(NodeType nodeType, String mDataJson) {
        List mDatas = null;
        if (NodeType.TASK_TRACKER == nodeType) {
            mDatas = (List)JSON.parse((String)mDataJson, (Type)new TypeReference<List<TaskTrackerMData>>(){}.getType());
        } else if (NodeType.JOB_TRACKER == nodeType) {
            mDatas = (List)JSON.parse((String)mDataJson, (Type)new TypeReference<List<JobTrackerMData>>(){}.getType());
        } else if (NodeType.JOB_CLIENT == nodeType) {
            mDatas = (List)JSON.parse((String)mDataJson, (Type)new TypeReference<List<JobClientMData>>(){}.getType());
        }
        return mDatas;
    }

    private HttpCmdResponse paramCheck(MNode mNode) {
        if (mNode == null) {
            return HttpCmdResponse.newResponse((boolean)false, (String)"mNode is empty");
        }
        NodeType nodeType = mNode.getNodeType();
        if (nodeType == null || nodeType != NodeType.JOB_CLIENT && nodeType != NodeType.TASK_TRACKER && nodeType != NodeType.JOB_TRACKER) {
            return HttpCmdResponse.newResponse((boolean)false, (String)"nodeType error");
        }
        if (StringUtils.isEmpty((String)mNode.getNodeGroup())) {
            return HttpCmdResponse.newResponse((boolean)false, (String)"nodeGroup is empty");
        }
        if (StringUtils.isEmpty((String)mNode.getIdentity())) {
            return HttpCmdResponse.newResponse((boolean)false, (String)"identity is empty");
        }
        return null;
    }
}

