/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.monitor;

import com.github.ltsopensource.core.commons.file.FileUtils;
import com.github.ltsopensource.core.commons.utils.Assert;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.monitor.CfgException;
import com.github.ltsopensource.monitor.MonitorCfg;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;

public class MonitorCfgLoader {
    public static MonitorCfg load(String confPath) {
        String cfgPath = confPath + "/lts-monitor.cfg";
        String log4jPath = confPath + "/log4j.properties";
        Properties conf = new Properties();
        File file = new File(cfgPath);
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new CfgException("can not find " + cfgPath);
        }
        try {
            conf.load(is);
        }
        catch (IOException e) {
            throw new CfgException("Read " + cfgPath + " error.", e);
        }
        MonitorCfg cfg = new MonitorCfg();
        try {
            String identity;
            String registryAddress = conf.getProperty("registryAddress");
            Assert.hasText((String)registryAddress, (String)"registryAddress can not be null.");
            cfg.setRegistryAddress(registryAddress);
            String clusterName = conf.getProperty("clusterName");
            Assert.hasText((String)clusterName, (String)"clusterName can not be null.");
            cfg.setClusterName(clusterName);
            String bindIp = conf.getProperty("bindIp");
            if (StringUtils.isNotEmpty((String[])new String[]{bindIp})) {
                cfg.setBindIp(bindIp);
            }
            if (StringUtils.isNotEmpty((String[])new String[]{identity = conf.getProperty("identity")})) {
                cfg.setBindIp(identity);
            }
            HashMap<String, String> configs = new HashMap<String, String>();
            for (Map.Entry<Object, Object> entry : conf.entrySet()) {
                String key = entry.getKey().toString();
                if (!key.startsWith("configs.")) continue;
                String value = entry.getValue() == null ? null : entry.getValue().toString();
                configs.put(key.replace("configs.", ""), value);
            }
            cfg.setConfigs(configs);
        }
        catch (Exception e) {
            throw new CfgException(e);
        }
        if (FileUtils.exist((String)log4jPath)) {
            PropertyConfigurator.configure((String)log4jPath);
        }
        return cfg;
    }
}

