/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.monitor;

import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.monitor.CfgException;
import com.github.ltsopensource.monitor.MonitorAgent;
import com.github.ltsopensource.monitor.MonitorCfg;
import com.github.ltsopensource.monitor.MonitorCfgLoader;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class MonitorAgentStartup {
    private static final MonitorAgent agent = new MonitorAgent();
    private static final AtomicBoolean started = new AtomicBoolean(false);

    public static void main(String[] args) {
        String cfgPath = args[0];
        MonitorAgentStartup.start(cfgPath);
    }

    public static void start(String cfgPath) {
        if (!started.compareAndSet(false, true)) {
            return;
        }
        try {
            MonitorCfg cfg = MonitorCfgLoader.load(cfgPath);
            agent.setRegistryAddress(cfg.getRegistryAddress());
            agent.setClusterName(cfg.getClusterName());
            if (StringUtils.isNotEmpty((String[])new String[]{cfg.getBindIp()})) {
                agent.setBindIp(cfg.getBindIp());
            }
            if (StringUtils.isNotEmpty((String[])new String[]{cfg.getIdentity()})) {
                agent.setIdentity(cfg.getIdentity());
            }
            for (Map.Entry<String, String> config : cfg.getConfigs().entrySet()) {
                agent.addConfig(config.getKey(), config.getValue());
            }
            agent.start();
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    agent.stop();
                }
            }));
        }
        catch (CfgException e) {
            System.err.println("Monitor Startup Error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void stop() {
        if (started.compareAndSet(true, false)) {
            agent.stop();
        }
    }
}

