/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.monitor;

import com.github.ltsopensource.cmd.HttpCmdProc;
import com.github.ltsopensource.cmd.HttpCmdServer;
import com.github.ltsopensource.core.AppContext;
import com.github.ltsopensource.core.cluster.Config;
import com.github.ltsopensource.core.cluster.Node;
import com.github.ltsopensource.core.cmd.JVMInfoGetHttpCmd;
import com.github.ltsopensource.core.cmd.StatusCheckHttpCmd;
import com.github.ltsopensource.core.commons.utils.NetUtils;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.factory.JobNodeConfigFactory;
import com.github.ltsopensource.core.factory.NodeFactory;
import com.github.ltsopensource.core.json.JSONFactory;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.registry.AbstractRegistry;
import com.github.ltsopensource.core.registry.Registry;
import com.github.ltsopensource.core.registry.RegistryFactory;
import com.github.ltsopensource.core.registry.RegistryStatMonitor;
import com.github.ltsopensource.core.spi.ServiceLoader;
import com.github.ltsopensource.core.support.AliveKeeping;
import com.github.ltsopensource.ec.EventCenter;
import com.github.ltsopensource.jvmmonitor.JVMMonitor;
import com.github.ltsopensource.monitor.MonitorAppContext;
import com.github.ltsopensource.monitor.MonitorNode;
import com.github.ltsopensource.monitor.access.MonitorAccessFactory;
import com.github.ltsopensource.monitor.cmd.MDataAddHttpCmd;
import com.github.ltsopensource.monitor.cmd.MDataSrv;
import java.util.concurrent.atomic.AtomicBoolean;

public class MonitorAgent {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorAgent.class);
    private HttpCmdServer httpCmdServer;
    private MonitorAppContext appContext;
    private Config config;
    private Registry registry;
    private MonitorNode node;
    private AtomicBoolean start = new AtomicBoolean(false);

    public MonitorAgent() {
        this.appContext = new MonitorAppContext();
        this.node = (MonitorNode)NodeFactory.create(MonitorNode.class);
        this.config = JobNodeConfigFactory.getDefaultConfig();
        this.config.setNodeType(this.node.getNodeType());
        this.appContext.setConfig(this.config);
    }

    public void start() {
        if (!this.start.compareAndSet(false, true)) {
            return;
        }
        try {
            this.intConfig();
            int port = this.config.getParameter("lts.http.cmd.port", 8730);
            this.httpCmdServer = HttpCmdServer.Factory.getHttpCmdServer((String)this.config.getIp(), (int)port);
            this.httpCmdServer.registerCommands(new HttpCmdProc[]{new MDataAddHttpCmd(this.appContext), new StatusCheckHttpCmd(this.config), new JVMInfoGetHttpCmd(this.config)});
            this.httpCmdServer.start();
            this.appContext.setHttpCmdPort(this.httpCmdServer.getPort());
            this.initNode();
            this.initRegistry();
            this.registry.register((Node)this.node);
            JVMMonitor.start();
            AliveKeeping.start();
            LOGGER.error("========== Start Monitor Success");
        }
        catch (Throwable t) {
            LOGGER.error("========== Start Monitor Error:", t);
        }
    }

    public void initRegistry() {
        this.registry = RegistryFactory.getRegistry((AppContext)this.appContext);
        if (this.registry instanceof AbstractRegistry) {
            ((AbstractRegistry)this.registry).setNode((Node)this.node);
        }
    }

    private void initNode() {
        this.config.setListenPort(this.appContext.getHttpCmdPort());
        NodeFactory.build((Node)this.node, (Config)this.config);
        this.node.setHttpCmdPort(this.appContext.getHttpCmdPort());
    }

    private void intConfig() {
        MonitorAccessFactory factory = (MonitorAccessFactory)ServiceLoader.load(MonitorAccessFactory.class, (Config)this.config);
        this.appContext.setJobTrackerMAccess(factory.getJobTrackerMAccess(this.config));
        this.appContext.setJvmGCAccess(factory.getJVMGCAccess(this.config));
        this.appContext.setJvmMemoryAccess(factory.getJVMMemoryAccess(this.config));
        this.appContext.setJvmThreadAccess(factory.getJVMThreadAccess(this.config));
        this.appContext.setTaskTrackerMAccess(factory.getTaskTrackerMAccess(this.config));
        this.appContext.setJobClientMAccess(factory.getJobClientMAccess(this.config));
        this.appContext.setMDataSrv(new MDataSrv(this.appContext));
        this.appContext.setEventCenter((EventCenter)ServiceLoader.load(EventCenter.class, (Config)this.config));
        this.appContext.setRegistryStatMonitor(new RegistryStatMonitor((AppContext)this.appContext));
        String ltsJson = this.config.getParameter("lts.json");
        if (StringUtils.isNotEmpty((String[])new String[]{ltsJson})) {
            JSONFactory.setJSONAdapter((String)ltsJson);
        }
        if (StringUtils.isEmpty((String)this.config.getIp())) {
            this.config.setIp(NetUtils.getLocalHost());
        }
        JobNodeConfigFactory.buildIdentity((Config)this.config);
    }

    public void stop() {
        if (!this.start.compareAndSet(true, false)) {
            return;
        }
        try {
            if (this.registry != null) {
                this.registry.unregister((Node)this.node);
            }
            if (this.httpCmdServer != null) {
                this.httpCmdServer.stop();
            }
            JVMMonitor.stop();
            AliveKeeping.stop();
            LOGGER.error("========== Stop Monitor Success");
        }
        catch (Throwable t) {
            LOGGER.error("========== Stop Monitor Error:", t);
        }
    }

    public void setClusterName(String clusterName) {
        this.config.setClusterName(clusterName);
    }

    public void setRegistryAddress(String registryAddress) {
        this.config.setRegistryAddress(registryAddress);
    }

    public void addConfig(String key, String value) {
        this.config.setParameter(key, value);
    }

    public void setIdentity(String identity) {
        this.config.setIdentity(identity);
    }

    public void setBindIp(String bindIp) {
        if (StringUtils.isEmpty((String)bindIp) || !NetUtils.isValidHost((String)bindIp)) {
            throw new IllegalArgumentException("Invalided bind ip:" + bindIp);
        }
        this.config.setIp(bindIp);
    }
}

