/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.zookeeper.support;

import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.zookeeper.ChildListener;
import com.github.ltsopensource.zookeeper.DataListener;
import com.github.ltsopensource.zookeeper.StateListener;
import com.github.ltsopensource.zookeeper.ZkClient;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;

public abstract class AbstractZkClient<TargetChildListener, TargetDataListener>
implements ZkClient {
    private static final Logger logger = LoggerFactory.getLogger(AbstractZkClient.class);
    private final Set<StateListener> stateListeners = new CopyOnWriteArraySet<StateListener>();
    private final ConcurrentMap<String, ConcurrentMap<ChildListener, TargetChildListener>> childListeners = new ConcurrentHashMap<String, ConcurrentMap<ChildListener, TargetChildListener>>();
    private final ConcurrentMap<String, ConcurrentMap<DataListener, TargetDataListener>> dataListeners = new ConcurrentHashMap<String, ConcurrentMap<DataListener, TargetDataListener>>();
    private volatile boolean closed = false;

    @Override
    public String create(String path, boolean ephemeral, boolean sequential) {
        int i = path.lastIndexOf(47);
        if (i > 0) {
            this.create(path.substring(0, i), false, false);
        }
        if (ephemeral) {
            return this.createEphemeral(path, sequential);
        }
        return this.createPersistent(path, sequential);
    }

    @Override
    public String create(String path, Object data, boolean ephemeral, boolean sequential) {
        int i = path.lastIndexOf(47);
        if (i > 0) {
            this.create(path.substring(0, i), data, false, false);
        }
        if (ephemeral) {
            return this.createEphemeral(path, data, sequential);
        }
        return this.createPersistent(path, data, sequential);
    }

    public Set<StateListener> getSessionListeners() {
        return this.stateListeners;
    }

    @Override
    public void addStateListener(StateListener listener) {
        this.stateListeners.add(listener);
    }

    @Override
    public void removeStateListener(StateListener listener) {
        this.stateListeners.remove(listener);
    }

    @Override
    public List<String> addChildListener(String path, ChildListener listener) {
        Object targetListener;
        ConcurrentMap listeners = (ConcurrentMap)this.childListeners.get(path);
        if (listeners == null) {
            this.childListeners.putIfAbsent(path, new ConcurrentHashMap());
            listeners = (ConcurrentMap)this.childListeners.get(path);
        }
        if ((targetListener = listeners.get(listener)) == null) {
            listeners.putIfAbsent(listener, this.createTargetChildListener(path, listener));
            targetListener = listeners.get(listener);
        }
        return this.addTargetChildListener(path, targetListener);
    }

    @Override
    public void removeChildListener(String path, ChildListener listener) {
        Object targetListener;
        ConcurrentMap listeners = (ConcurrentMap)this.childListeners.get(path);
        if (listeners != null && (targetListener = listeners.remove(listener)) != null) {
            this.removeTargetChildListener(path, targetListener);
        }
    }

    @Override
    public void addDataListener(String path, DataListener listener) {
        Object targetListener;
        ConcurrentMap listeners = (ConcurrentMap)this.dataListeners.get(path);
        if (listeners == null) {
            this.dataListeners.putIfAbsent(path, new ConcurrentHashMap());
            listeners = (ConcurrentMap)this.dataListeners.get(path);
        }
        if ((targetListener = listeners.get(listener)) == null) {
            listeners.putIfAbsent(listener, this.createTargetDataListener(path, listener));
            targetListener = listeners.get(listener);
        }
        this.addTargetDataListener(path, targetListener);
    }

    @Override
    public void removeDataListener(String path, DataListener listener) {
        Object targetListener;
        ConcurrentMap listeners = (ConcurrentMap)this.dataListeners.get(path);
        if (listeners != null && (targetListener = listeners.remove(listener)) != null) {
            this.removeTargetDataListener(path, targetListener);
        }
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.doClose();
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), e);
        }
    }

    protected void stateChanged(int state) {
        for (StateListener stateListener : this.getSessionListeners()) {
            stateListener.stateChanged(state);
        }
    }

    protected abstract void doClose();

    protected abstract String createPersistent(String var1, boolean var2);

    protected abstract String createPersistent(String var1, Object var2, boolean var3);

    protected abstract String createEphemeral(String var1, boolean var2);

    protected abstract String createEphemeral(String var1, Object var2, boolean var3);

    protected abstract TargetChildListener createTargetChildListener(String var1, ChildListener var2);

    protected abstract List<String> addTargetChildListener(String var1, TargetChildListener var2);

    protected abstract void removeTargetChildListener(String var1, TargetChildListener var2);

    protected abstract void addTargetDataListener(String var1, TargetDataListener var2);

    protected abstract TargetDataListener createTargetDataListener(String var1, DataListener var2);

    protected abstract void removeTargetDataListener(String var1, TargetDataListener var2);
}

