/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.store.jdbc.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import com.github.ltsopensource.core.cluster.Config;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.store.jdbc.datasource.DataSourceProvider;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

public class MysqlDataSourceProvider
implements DataSourceProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(MysqlDataSourceProvider.class);
    private static final ConcurrentHashMap<String, DataSource> DATA_SOURCE_MAP = new ConcurrentHashMap();
    private static final Object lock = new Object();
    private static final Map<String, Class<?>> FIELDS = new ConcurrentHashMap();
    private static final String URL_KEY = "jdbc.url";
    private static final String USERNAME_KEY = "jdbc.username";
    private static final String PASSWORD_KEY = "jdbc.password";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSource getDataSource(Config config) {
        String url = config.getParameter(URL_KEY);
        String username = config.getParameter(USERNAME_KEY);
        String password = config.getParameter(PASSWORD_KEY);
        if (StringUtils.isEmpty(url)) {
            throw new IllegalArgumentException("jdbc.url should not be empty");
        }
        if (StringUtils.isEmpty(USERNAME_KEY)) {
            throw new IllegalArgumentException("jdbc.username should not be empty");
        }
        String cachedKey = StringUtils.concat(url, username, password);
        DataSource dataSource = DATA_SOURCE_MAP.get(cachedKey);
        if (dataSource == null) {
            try {
                Object object = lock;
                synchronized (object) {
                    dataSource = DATA_SOURCE_MAP.get(cachedKey);
                    if (dataSource != null) {
                        return dataSource;
                    }
                    dataSource = this.createDruidDataSource(config);
                    DATA_SOURCE_MAP.put(cachedKey, dataSource);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(StringUtils.format("connect datasource failed! url: {}", url), e);
            }
        }
        return dataSource;
    }

    private DataSource createDruidDataSource(Config config) {
        DruidDataSource dataSource = new DruidDataSource();
        Class<DruidDataSource> clazz = DruidDataSource.class;
        for (Map.Entry<String, Class<?>> entry : FIELDS.entrySet()) {
            String field = entry.getKey();
            String value = config.getParameter("druid." + field);
            if (!StringUtils.isNotEmpty(value)) continue;
            Method setMethod = null;
            try {
                setMethod = clazz.getMethod("set" + field.substring(0, 1).toUpperCase() + field.substring(1), entry.getValue());
                setMethod.invoke((Object)dataSource, value);
            }
            catch (Exception e) {
                LOGGER.warn("set field[{}] failed! value is {}", field, value);
            }
        }
        String url = config.getParameter(URL_KEY);
        String username = config.getParameter(USERNAME_KEY);
        String password = config.getParameter(PASSWORD_KEY);
        dataSource.setUrl(url);
        dataSource.setUsername(username);
        dataSource.setPassword(password);
        return dataSource;
    }

    static {
        FIELDS.put("initialSize", Integer.class);
        FIELDS.put("maxActive", Integer.class);
        FIELDS.put("maxIdle", Integer.class);
        FIELDS.put("minIdle", Integer.class);
        FIELDS.put("maxWait", Integer.class);
        FIELDS.put("poolPreparedStatements", Boolean.class);
        FIELDS.put("maxOpenPreparedStatements", Integer.class);
        FIELDS.put("validationQuery", String.class);
        FIELDS.put("testOnBorrow", Boolean.class);
        FIELDS.put("testOnReturn", Boolean.class);
        FIELDS.put("testWhileIdle", Boolean.class);
        FIELDS.put("timeBetweenEvictionRunsMillis", Long.class);
        FIELDS.put("numTestsPerEvictionRun", Integer.class);
        FIELDS.put("minEvictableIdleTimeMillis", Long.class);
        FIELDS.put("exceptionSorter", String.class);
        FIELDS.put("filters", String.class);
    }
}

